/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

public class FunctionReference
extends SpelNodeImpl {
    private final String name;

    public FunctionReference(String functionName, int pos, SpelNodeImpl ... arguments2) {
        super(pos, arguments2);
        this.name = functionName;
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue o = state2.lookupVariable(this.name);
        if (o == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_NOT_DEFINED, this.name);
        }
        if (!(o.getValue() instanceof Method)) {
            throw new SpelEvaluationException(SpelMessage.FUNCTION_REFERENCE_CANNOT_BE_INVOKED, this.name, o.getClass());
        }
        try {
            return this.executeFunctionJLRMethod(state2, (Method)o.getValue());
        }
        catch (SpelEvaluationException se) {
            se.setPosition(this.getStartPosition());
            throw se;
        }
    }

    private TypedValue executeFunctionJLRMethod(ExpressionState state2, Method method) throws EvaluationException {
        Object[] functionArgs = this.getArguments(state2);
        if (!method.isVarArgs() && method.getParameterTypes().length != functionArgs.length) {
            throw new SpelEvaluationException(SpelMessage.INCORRECT_NUMBER_OF_ARGUMENTS_TO_FUNCTION, functionArgs.length, method.getParameterTypes().length);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.FUNCTION_MUST_BE_STATIC, String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName(), this.name);
        }
        if (functionArgs != null) {
            TypeConverter converter = state2.getEvaluationContext().getTypeConverter();
            ReflectionHelper.convertAllArguments(converter, functionArgs, method);
        }
        if (method.isVarArgs()) {
            functionArgs = ReflectionHelper.setupArgumentsForVarargsInvocation(method.getParameterTypes(), functionArgs);
        }
        try {
            ReflectionUtils.makeAccessible(method);
            Object result2 = method.invoke(method.getClass(), functionArgs);
            return new TypedValue(result2, new TypeDescriptor(new MethodParameter(method, -1)).narrow(result2));
        }
        catch (Exception ex2) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex2, SpelMessage.EXCEPTION_DURING_FUNCTION_CALL, this.name, ex2.getMessage());
        }
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder("#").append(this.name);
        sb.append("(");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private Object[] getArguments(ExpressionState state2) throws EvaluationException {
        Object[] arguments2 = new Object[this.getChildCount()];
        int i = 0;
        while (i < arguments2.length) {
            arguments2[i] = this.children[i].getValueInternal(state2).getValue();
            ++i;
        }
        return arguments2;
    }
}

