/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.AstUtils;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

public class Indexer
extends SpelNodeImpl {
    private String cachedReadName;
    private Class<?> cachedReadTargetType;
    private PropertyAccessor cachedReadAccessor;
    private String cachedWriteName;
    private Class<?> cachedWriteTargetType;
    private PropertyAccessor cachedWriteAccessor;

    public Indexer(int pos, SpelNodeImpl expr2) {
        super(pos, expr2);
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue context = state2.getActiveContextObject();
        Object targetObject = context.getValue();
        TypeDescriptor targetObjectTypeDescriptor = context.getTypeDescriptor();
        TypedValue indexValue = null;
        Object index2 = null;
        if (targetObject instanceof Map && this.children[0] instanceof PropertyOrFieldReference) {
            PropertyOrFieldReference reference = (PropertyOrFieldReference)this.children[0];
            index2 = reference.getName();
            indexValue = new TypedValue(index2);
        } else {
            try {
                state2.pushActiveContextObject(state2.getRootContextObject());
                indexValue = this.children[0].getValueInternal(state2);
                index2 = indexValue.getValue();
            }
            finally {
                state2.popActiveContextObject();
            }
        }
        if (targetObject instanceof Map) {
            Object key = index2;
            if (targetObjectTypeDescriptor.getMapKeyTypeDescriptor() != null) {
                key = state2.convertValue(key, targetObjectTypeDescriptor.getMapKeyTypeDescriptor());
            }
            Object value2 = ((Map)targetObject).get(key);
            return new TypedValue(value2, targetObjectTypeDescriptor.getMapValueTypeDescriptor(value2));
        }
        if (targetObject == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        if (targetObject instanceof Collection || targetObject.getClass().isArray() || targetObject instanceof String) {
            int idx = (Integer)state2.convertValue(index2, TypeDescriptor.valueOf(Integer.class));
            if (targetObject.getClass().isArray()) {
                Object arrayElement = this.accessArrayElement(targetObject, idx);
                return new TypedValue(arrayElement, targetObjectTypeDescriptor.elementTypeDescriptor(arrayElement));
            }
            if (targetObject instanceof Collection) {
                Collection c2 = (Collection)targetObject;
                if (idx >= c2.size() && !this.growCollection(state2, targetObjectTypeDescriptor, idx, c2)) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, c2.size(), idx);
                }
                int pos = 0;
                for (Object o : c2) {
                    if (pos == idx) {
                        return new TypedValue(o, targetObjectTypeDescriptor.elementTypeDescriptor(o));
                    }
                    ++pos;
                }
            } else if (targetObject instanceof String) {
                String ctxString = (String)targetObject;
                if (idx >= ctxString.length()) {
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, ctxString.length(), idx);
                }
                return new TypedValue(String.valueOf(ctxString.charAt(idx)));
            }
        }
        if (indexValue.getTypeDescriptor().getType() == String.class) {
            Class<?> targetObjectRuntimeClass = this.getObjectClass(targetObject);
            String name = (String)indexValue.getValue();
            EvaluationContext eContext = state2.getEvaluationContext();
            try {
                if (this.cachedReadName != null && this.cachedReadName.equals(name) && this.cachedReadTargetType != null && this.cachedReadTargetType.equals(targetObjectRuntimeClass)) {
                    return this.cachedReadAccessor.read(eContext, targetObject, name);
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(targetObjectRuntimeClass, state2);
                if (accessorsToTry != null) {
                    for (PropertyAccessor accessor : accessorsToTry) {
                        if (!accessor.canRead(eContext, targetObject, name)) continue;
                        if (accessor instanceof ReflectivePropertyAccessor) {
                            accessor = ((ReflectivePropertyAccessor)accessor).createOptimalAccessor(eContext, targetObject, name);
                        }
                        this.cachedReadAccessor = accessor;
                        this.cachedReadName = name;
                        this.cachedReadTargetType = targetObjectRuntimeClass;
                        return accessor.read(eContext, targetObject, name);
                    }
                }
            }
            catch (AccessException e2) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)e2, SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return true;
    }

    public void setValue(ExpressionState state2, Object newValue) throws EvaluationException {
        TypedValue contextObject = state2.getActiveContextObject();
        Object targetObject = contextObject.getValue();
        TypeDescriptor targetObjectTypeDescriptor = contextObject.getTypeDescriptor();
        TypedValue index2 = this.children[0].getValueInternal(state2);
        if (targetObject == null) {
            throw new SpelEvaluationException(SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        if (targetObject instanceof Map) {
            Map map3 = (Map)targetObject;
            Object key = index2.getValue();
            if (targetObjectTypeDescriptor.getMapKeyTypeDescriptor() != null) {
                key = state2.convertValue(index2, targetObjectTypeDescriptor.getMapKeyTypeDescriptor());
            }
            if (targetObjectTypeDescriptor.getMapValueTypeDescriptor() != null) {
                newValue = state2.convertValue(newValue, targetObjectTypeDescriptor.getMapValueTypeDescriptor());
            }
            map3.put(key, newValue);
            return;
        }
        if (targetObjectTypeDescriptor.isArray()) {
            int idx = (Integer)state2.convertValue(index2, TypeDescriptor.valueOf(Integer.class));
            this.setArrayElement(state2, contextObject.getValue(), idx, newValue, targetObjectTypeDescriptor.getElementTypeDescriptor().getType());
            return;
        }
        if (targetObject instanceof Collection) {
            Collection c2;
            int idx = (Integer)state2.convertValue(index2, TypeDescriptor.valueOf(Integer.class));
            if (idx >= (c2 = (Collection)targetObject).size() && !this.growCollection(state2, targetObjectTypeDescriptor, idx, c2)) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, c2.size(), idx);
            }
            if (targetObject instanceof List) {
                List list2 = (List)targetObject;
                if (targetObjectTypeDescriptor.getElementTypeDescriptor() != null) {
                    newValue = state2.convertValue(newValue, targetObjectTypeDescriptor.getElementTypeDescriptor());
                }
                list2.set(idx, newValue);
                return;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
        }
        if (index2.getTypeDescriptor().getType() == String.class) {
            Class<?> contextObjectClass = this.getObjectClass(contextObject.getValue());
            String name = (String)index2.getValue();
            EvaluationContext eContext = state2.getEvaluationContext();
            try {
                if (this.cachedWriteName != null && this.cachedWriteName.equals(name) && this.cachedWriteTargetType != null && this.cachedWriteTargetType.equals(contextObjectClass)) {
                    this.cachedWriteAccessor.write(eContext, targetObject, name, newValue);
                    return;
                }
                List<PropertyAccessor> accessorsToTry = AstUtils.getPropertyAccessorsToTry(contextObjectClass, state2);
                if (accessorsToTry != null) {
                    for (PropertyAccessor accessor : accessorsToTry) {
                        if (!accessor.canWrite(eContext, contextObject.getValue(), name)) continue;
                        this.cachedWriteName = name;
                        this.cachedWriteTargetType = contextObjectClass;
                        this.cachedWriteAccessor = accessor;
                        accessor.write(eContext, contextObject.getValue(), name, newValue);
                        return;
                    }
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, name, ae.getMessage());
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetObjectTypeDescriptor.toString());
    }

    private boolean growCollection(ExpressionState state2, TypeDescriptor targetType, int index2, Collection collection) {
        if (state2.getConfiguration().isAutoGrowCollections()) {
            if (targetType.getElementTypeDescriptor() == null) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
            }
            TypeDescriptor elementType2 = targetType.getElementTypeDescriptor();
            Object newCollectionElement = null;
            try {
                int newElements = index2 - collection.size();
                while (newElements > 0) {
                    collection.add(elementType2.getType().newInstance());
                    --newElements;
                }
                newCollectionElement = elementType2.getType().newInstance();
            }
            catch (Exception ex2) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex2, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
            }
            collection.add(newCollectionElement);
            return true;
        }
        return false;
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private void setArrayElement(ExpressionState state2, Object ctx, int idx, Object newValue, Class clazz2) throws EvaluationException {
        Class arrayComponentType = clazz2;
        if (arrayComponentType == Integer.TYPE) {
            int[] array2 = (int[])ctx;
            this.checkAccess(array2.length, idx);
            array2[idx] = (Integer)state2.convertValue(newValue, TypeDescriptor.valueOf(Integer.class));
        } else if (arrayComponentType == Boolean.TYPE) {
            boolean[] array3 = (boolean[])ctx;
            this.checkAccess(array3.length, idx);
            array3[idx] = (Boolean)state2.convertValue(newValue, TypeDescriptor.valueOf(Boolean.class));
        } else if (arrayComponentType == Character.TYPE) {
            char[] array4 = (char[])ctx;
            this.checkAccess(array4.length, idx);
            array4[idx] = ((Character)state2.convertValue(newValue, TypeDescriptor.valueOf(Character.class))).charValue();
        } else if (arrayComponentType == Long.TYPE) {
            long[] array5 = (long[])ctx;
            this.checkAccess(array5.length, idx);
            array5[idx] = (Long)state2.convertValue(newValue, TypeDescriptor.valueOf(Long.class));
        } else if (arrayComponentType == Short.TYPE) {
            short[] array6 = (short[])ctx;
            this.checkAccess(array6.length, idx);
            array6[idx] = (Short)state2.convertValue(newValue, TypeDescriptor.valueOf(Short.class));
        } else if (arrayComponentType == Double.TYPE) {
            double[] array7 = (double[])ctx;
            this.checkAccess(array7.length, idx);
            array7[idx] = (Double)state2.convertValue(newValue, TypeDescriptor.valueOf(Double.class));
        } else if (arrayComponentType == Float.TYPE) {
            float[] array8 = (float[])ctx;
            this.checkAccess(array8.length, idx);
            array8[idx] = ((Float)state2.convertValue(newValue, TypeDescriptor.valueOf(Float.class))).floatValue();
        } else if (arrayComponentType == Byte.TYPE) {
            byte[] array9 = (byte[])ctx;
            this.checkAccess(array9.length, idx);
            array9[idx] = (Byte)state2.convertValue(newValue, TypeDescriptor.valueOf(Byte.class));
        } else {
            Object[] array10 = (Object[])ctx;
            this.checkAccess(array10.length, idx);
            array10[idx] = state2.convertValue(newValue, TypeDescriptor.valueOf(clazz2));
        }
    }

    private Object accessArrayElement(Object ctx, int idx) throws SpelEvaluationException {
        Class<?> arrayComponentType = ctx.getClass().getComponentType();
        if (arrayComponentType == Integer.TYPE) {
            int[] array2 = (int[])ctx;
            this.checkAccess(array2.length, idx);
            return array2[idx];
        }
        if (arrayComponentType == Boolean.TYPE) {
            boolean[] array3 = (boolean[])ctx;
            this.checkAccess(array3.length, idx);
            return array3[idx];
        }
        if (arrayComponentType == Character.TYPE) {
            char[] array4 = (char[])ctx;
            this.checkAccess(array4.length, idx);
            return Character.valueOf(array4[idx]);
        }
        if (arrayComponentType == Long.TYPE) {
            long[] array5 = (long[])ctx;
            this.checkAccess(array5.length, idx);
            return array5[idx];
        }
        if (arrayComponentType == Short.TYPE) {
            short[] array6 = (short[])ctx;
            this.checkAccess(array6.length, idx);
            return array6[idx];
        }
        if (arrayComponentType == Double.TYPE) {
            double[] array7 = (double[])ctx;
            this.checkAccess(array7.length, idx);
            return array7[idx];
        }
        if (arrayComponentType == Float.TYPE) {
            float[] array8 = (float[])ctx;
            this.checkAccess(array8.length, idx);
            return Float.valueOf(array8[idx]);
        }
        if (arrayComponentType == Byte.TYPE) {
            byte[] array9 = (byte[])ctx;
            this.checkAccess(array9.length, idx);
            return array9[idx];
        }
        Object[] array10 = (Object[])ctx;
        this.checkAccess(array10.length, idx);
        return array10[idx];
    }

    private void checkAccess(int arrayLength, int index2) throws SpelEvaluationException {
        if (index2 > arrayLength) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index2);
        }
    }
}

