/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionInvocationTargetException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private volatile MethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe2, String methodName, int pos, SpelNodeImpl ... arguments2) {
        super(pos, arguments2);
        this.name = methodName;
        this.nullSafe = nullSafe2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue currentContext = state2.getActiveContextObject();
        Object[] arguments2 = new Object[this.getChildCount()];
        int i = 0;
        while (i < arguments2.length) {
            try {
                state2.pushActiveContextObject(state2.getRootContextObject());
                arguments2[i] = this.children[i].getValueInternal(state2).getValue();
            }
            finally {
                state2.popActiveContextObject();
            }
            ++i;
        }
        if (currentContext.getValue() == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, this.getTypes(arguments2)));
        }
        MethodExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state2.getEvaluationContext(), state2.getActiveContextObject().getValue(), arguments2);
            }
            catch (AccessException ae) {
                this.throwSimpleExceptionIfPossible(state2, ae);
                this.cachedExecutor = null;
            }
        }
        this.cachedExecutor = executorToUse = this.findAccessorForMethod(this.name, this.getTypes(arguments2), state2);
        try {
            return executorToUse.execute(state2.getEvaluationContext(), state2.getActiveContextObject().getValue(), arguments2);
        }
        catch (AccessException ae) {
            this.throwSimpleExceptionIfPossible(state2, ae);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, state2.getActiveContextObject().getValue().getClass().getName(), ae.getMessage());
        }
    }

    private void throwSimpleExceptionIfPossible(ExpressionState state2, AccessException ae) {
        if (ae.getCause() instanceof InvocationTargetException) {
            Throwable rootCause = ae.getCause().getCause();
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type '" + state2.getActiveContextObject().getValue().getClass().getName() + "'", rootCause);
        }
    }

    private List<TypeDescriptor> getTypes(Object ... arguments2) {
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments2.length);
        Object[] objectArray = arguments2;
        int n = arguments2.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument2 = objectArray[n2];
            descriptors.add(TypeDescriptor.forObject(argument2));
            ++n2;
        }
        return descriptors;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        int i = 0;
        while (i < this.getChildCount()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, ExpressionState state2) throws SpelEvaluationException {
        TypedValue context = state2.getActiveContextObject();
        Object contextObject = context.getValue();
        EvaluationContext eContext = state2.getEvaluationContext();
        List<MethodResolver> mResolvers = eContext.getMethodResolvers();
        if (mResolvers != null) {
            for (MethodResolver methodResolver : mResolvers) {
                try {
                    MethodExecutor cEx = methodResolver.resolve(state2.getEvaluationContext(), contextObject, name, argumentTypes);
                    if (cEx == null) continue;
                    return cEx;
                }
                catch (AccessException ex2) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex2, SpelMessage.PROBLEM_LOCATING_METHOD, name, contextObject.getClass());
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, FormatHelper.formatMethodForMessage(name, argumentTypes), FormatHelper.formatClassNameForMessage(contextObject instanceof Class ? (Class<?>)contextObject : contextObject.getClass()));
    }
}

