/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpEQ
extends Operator {
    public OpEQ(int pos, SpelNodeImpl ... operands) {
        super("==", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        Object left2 = this.getLeftOperand().getValueInternal(state2).getValue();
        Object right2 = this.getRightOperand().getValueInternal(state2).getValue();
        if (left2 instanceof Number && right2 instanceof Number) {
            Number op1 = (Number)left2;
            Number op2 = (Number)right2;
            if (op1 instanceof Double || op2 instanceof Double) {
                return BooleanTypedValue.forValue(op1.doubleValue() == op2.doubleValue());
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return BooleanTypedValue.forValue(op1.longValue() == op2.longValue());
            }
            return BooleanTypedValue.forValue(op1.intValue() == op2.intValue());
        }
        if (left2 != null && left2 instanceof Comparable) {
            return BooleanTypedValue.forValue(state2.getTypeComparator().compare(left2, right2) == 0);
        }
        return BooleanTypedValue.forValue(left2 == right2);
    }
}

