/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpGE
extends Operator {
    public OpGE(int pos, SpelNodeImpl ... operands) {
        super(">=", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        Object left2 = this.getLeftOperand().getValueInternal(state2).getValue();
        Object right2 = this.getRightOperand().getValueInternal(state2).getValue();
        if (left2 instanceof Number && right2 instanceof Number) {
            Number leftNumber = (Number)left2;
            Number rightNumber = (Number)right2;
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return BooleanTypedValue.forValue(leftNumber.doubleValue() >= rightNumber.doubleValue());
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return BooleanTypedValue.forValue(leftNumber.longValue() >= rightNumber.longValue());
            }
            return BooleanTypedValue.forValue(leftNumber.intValue() >= rightNumber.intValue());
        }
        return BooleanTypedValue.forValue(state2.getTypeComparator().compare(left2, right2) >= 0);
    }
}

