/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OpMinus
extends Operator {
    public OpMinus(int pos, SpelNodeImpl ... operands) {
        super("-", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        if (rightOp == null) {
            Object operand = leftOp.getValueInternal(state2).getValue();
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (operand instanceof Double) {
                    return new TypedValue(0.0 - n.doubleValue());
                }
                if (operand instanceof Long) {
                    return new TypedValue(0L - n.longValue());
                }
                return new TypedValue(0 - n.intValue());
            }
            return state2.operate(Operation.SUBTRACT, operand, null);
        }
        Object left2 = leftOp.getValueInternal(state2).getValue();
        Object right2 = rightOp.getValueInternal(state2).getValue();
        if (left2 instanceof Number && right2 instanceof Number) {
            Number op1 = (Number)left2;
            Number op2 = (Number)right2;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(op1.doubleValue() - op2.doubleValue());
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return new TypedValue(op1.longValue() - op2.longValue());
            }
            return new TypedValue(op1.intValue() - op2.intValue());
        }
        if (left2 instanceof String && right2 instanceof Integer && ((String)left2).length() == 1) {
            String theString = (String)left2;
            Integer theInteger = (Integer)right2;
            return new TypedValue(Character.toString((char)(theString.charAt(0) - theInteger)));
        }
        return state2.operate(Operation.SUBTRACT, left2, right2);
    }

    public String toStringAST() {
        if (this.getRightOperand() == null) {
            return "-" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            return null;
        }
        return this.children[1];
    }
}

