/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int pos, SpelNodeImpl ... operands) {
        super("or", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        boolean rightValue;
        boolean leftValue;
        TypedValue typedValue;
        try {
            typedValue = this.getLeftOperand().getValueInternal(state2);
            this.assertTypedValueNotNull(typedValue);
            leftValue = (Boolean)state2.convertValue(typedValue, TypeDescriptor.valueOf(Boolean.class));
        }
        catch (SpelEvaluationException see2) {
            see2.setPosition(this.getLeftOperand().getStartPosition());
            throw see2;
        }
        if (leftValue) {
            return BooleanTypedValue.TRUE;
        }
        try {
            typedValue = this.getRightOperand().getValueInternal(state2);
            this.assertTypedValueNotNull(typedValue);
            rightValue = (Boolean)state2.convertValue(typedValue, TypeDescriptor.valueOf(Boolean.class));
        }
        catch (SpelEvaluationException see3) {
            see3.setPosition(this.getRightOperand().getStartPosition());
            throw see3;
        }
        return BooleanTypedValue.forValue(leftValue || rightValue);
    }

    private void assertTypedValueNotNull(TypedValue typedValue) {
        if (TypedValue.NULL.equals(typedValue)) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }
}

