/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OpPlus
extends Operator {
    public OpPlus(int pos, SpelNodeImpl ... operands) {
        super("+", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        if (rightOp == null) {
            Object operandOne = leftOp.getValueInternal(state2).getValue();
            if (operandOne instanceof Number) {
                if (operandOne instanceof Double) {
                    return new TypedValue((double)((Double)operandOne));
                }
                if (operandOne instanceof Long) {
                    return new TypedValue((long)((Long)operandOne));
                }
                return new TypedValue((int)((Integer)operandOne));
            }
            return state2.operate(Operation.ADD, operandOne, null);
        }
        Object operandOne = leftOp.getValueInternal(state2).getValue();
        Object operandTwo = rightOp.getValueInternal(state2).getValue();
        if (operandOne instanceof Number && operandTwo instanceof Number) {
            Number op1 = (Number)operandOne;
            Number op2 = (Number)operandTwo;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(op1.doubleValue() + op2.doubleValue());
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                return new TypedValue(op1.longValue() + op2.longValue());
            }
            return new TypedValue(op1.intValue() + op2.intValue());
        }
        if (operandOne instanceof String && operandTwo instanceof String) {
            return new TypedValue((String)operandOne + (String)operandTwo);
        }
        if (operandOne instanceof String) {
            StringBuilder result2 = new StringBuilder((String)operandOne);
            result2.append(operandTwo == null ? "null" : operandTwo.toString());
            return new TypedValue(result2.toString());
        }
        if (operandTwo instanceof String) {
            StringBuilder result3 = new StringBuilder(operandOne == null ? "null" : operandOne.toString());
            result3.append((String)operandTwo);
            return new TypedValue(result3.toString());
        }
        return state2.operate(Operation.ADD, operandOne, operandTwo);
    }

    public String toStringAST() {
        if (this.children.length < 2) {
            return "+" + this.getLeftOperand().toStringAST();
        }
        return super.toStringAST();
    }

    public SpelNodeImpl getRightOperand() {
        if (this.children.length < 2) {
            return null;
        }
        return this.children[1];
    }
}

