/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.List;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorBetween
extends Operator {
    public OperatorBetween(int pos, SpelNodeImpl ... operands) {
        super("between", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        Object left2 = this.getLeftOperand().getValueInternal(state2).getValue();
        Object right2 = this.getRightOperand().getValueInternal(state2).getValue();
        if (!(right2 instanceof List) || ((List)right2).size() != 2) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.BETWEEN_RIGHT_OPERAND_MUST_BE_TWO_ELEMENT_LIST, new Object[0]);
        }
        List l = (List)right2;
        Object low = l.get(0);
        Object high = l.get(1);
        TypeComparator comparator = state2.getTypeComparator();
        try {
            return BooleanTypedValue.forValue(comparator.compare(left2, low) >= 0 && comparator.compare(left2, high) <= 0);
        }
        catch (SpelEvaluationException ex2) {
            ex2.setPosition(this.getStartPosition());
            throw ex2;
        }
    }
}

