/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorInstanceof
extends Operator {
    public OperatorInstanceof(int pos, SpelNodeImpl ... operands) {
        super("instanceof", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue left2 = this.getLeftOperand().getValueInternal(state2);
        TypedValue right2 = this.getRightOperand().getValueInternal(state2);
        Object leftValue = left2.getValue();
        Object rightValue = right2.getValue();
        if (leftValue == null) {
            return BooleanTypedValue.FALSE;
        }
        if (rightValue == null || !(rightValue instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, rightValue == null ? "null" : rightValue.getClass().getName());
        }
        Class rightClass = (Class)rightValue;
        return BooleanTypedValue.forValue(rightClass.isAssignableFrom(leftValue.getClass()));
    }
}

