/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OperatorMatches
extends Operator {
    public OperatorMatches(int pos, SpelNodeImpl ... operands) {
        super("matches", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        String left2 = leftOp.getValue(state2, String.class);
        Object right2 = this.getRightOperand().getValueInternal(state2).getValue();
        try {
            if (!(left2 instanceof String)) {
                throw new SpelEvaluationException(leftOp.getStartPosition(), SpelMessage.INVALID_FIRST_OPERAND_FOR_MATCHES_OPERATOR, left2);
            }
            if (!(right2 instanceof String)) {
                throw new SpelEvaluationException(rightOp.getStartPosition(), SpelMessage.INVALID_SECOND_OPERAND_FOR_MATCHES_OPERATOR, right2);
            }
            Pattern pattern = Pattern.compile((String)right2);
            Matcher matcher2 = pattern.matcher(left2);
            return BooleanTypedValue.forValue(matcher2.matches());
        }
        catch (PatternSyntaxException pse) {
            throw new SpelEvaluationException(rightOp.getStartPosition(), (Throwable)pse, SpelMessage.INVALID_PATTERN, right2);
        }
    }
}

