/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe2, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue op = state2.getActiveContextObject();
        Object operand = op.getValue();
        boolean operandIsArray = ObjectUtils.isArray(operand);
        if (operand instanceof Map) {
            Map mapData = (Map)operand;
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (Map.Entry entry2 : mapData.entrySet()) {
                try {
                    state2.pushActiveContextObject(new TypedValue(entry2));
                    result2.add(this.children[0].getValueInternal(state2).getValue());
                }
                finally {
                    state2.popActiveContextObject();
                }
            }
            return new TypedValue(result2);
        }
        if (operand instanceof Collection || operandIsArray) {
            Collection data2 = operand instanceof Collection ? (Collection)operand : (Collection)Arrays.asList(ObjectUtils.toObjectArray(operand));
            ArrayList<Object> result3 = new ArrayList<Object>();
            int idx = 0;
            Class arrayElementType = null;
            for (Object element2 : data2) {
                try {
                    state2.pushActiveContextObject(new TypedValue(element2));
                    state2.enterScope("index", idx);
                    Object value2 = this.children[0].getValueInternal(state2).getValue();
                    if (value2 != null && operandIsArray) {
                        arrayElementType = this.determineCommonType(arrayElementType, value2.getClass());
                    }
                    result3.add(value2);
                }
                finally {
                    state2.exitScope();
                    state2.popActiveContextObject();
                }
                ++idx;
            }
            if (operandIsArray) {
                if (arrayElementType == null) {
                    arrayElementType = Object.class;
                }
                Object resultArray = Array.newInstance(arrayElementType, result3.size());
                System.arraycopy(result3.toArray(), 0, resultArray, 0, result3.size());
                return new TypedValue(resultArray);
            }
            return new TypedValue(result3);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        return sb.append("![").append(this.getChild(0).toStringAST()).append("]").toString();
    }

    private Class<?> determineCommonType(Class<?> oldType, Class<?> newType) {
        Class<?>[] interfaces2;
        if (oldType == null) {
            return newType;
        }
        if (oldType.isAssignableFrom(newType)) {
            return oldType;
        }
        Class<?> nextType = newType;
        while (nextType != Object.class) {
            if (nextType.isAssignableFrom(oldType)) {
                return nextType;
            }
            nextType = nextType.getSuperclass();
        }
        Class<?>[] classArray = interfaces2 = ClassUtils.getAllInterfacesForClass(newType);
        int n = interfaces2.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nextInterface = classArray[n2];
            if (nextInterface.isAssignableFrom(oldType)) {
                return nextInterface;
            }
            ++n2;
        }
        return Object.class;
    }
}

