/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyOrFieldReference
extends SpelNodeImpl {
    private final boolean nullSafe;
    private final String name;
    private volatile PropertyAccessor cachedReadAccessor;
    private volatile PropertyAccessor cachedWriteAccessor;

    public PropertyOrFieldReference(boolean nullSafe2, String propertyOrFieldName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.nullSafe = nullSafe2;
        this.name = propertyOrFieldName;
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue result2 = this.readProperty(state2, this.name);
        if (result2.getValue() != null) return result2;
        if (!state2.getConfiguration().isAutoGrowNullReferences()) return result2;
        if (!this.nextChildIs(Indexer.class, PropertyOrFieldReference.class)) return result2;
        TypeDescriptor resultDescriptor = result2.getTypeDescriptor();
        if (resultDescriptor.getType().equals(List.class) || resultDescriptor.getType().equals(Map.class)) {
            if (resultDescriptor.getType().equals(List.class)) {
                try {
                    if (!this.isWritable(state2)) return result2;
                    List newList = (List)ArrayList.class.newInstance();
                    this.writeProperty(state2, this.name, newList);
                    return this.readProperty(state2, this.name);
                }
                catch (InstantiationException ex2) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex2, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
                catch (IllegalAccessException ex3) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex3, SpelMessage.UNABLE_TO_CREATE_LIST_FOR_INDEXING, new Object[0]);
                }
            }
            try {
                if (!this.isWritable(state2)) return result2;
                Map newMap = (Map)HashMap.class.newInstance();
                this.writeProperty(state2, this.name, newMap);
                return this.readProperty(state2, this.name);
            }
            catch (InstantiationException ex4) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex4, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
            catch (IllegalAccessException ex5) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex5, SpelMessage.UNABLE_TO_CREATE_MAP_FOR_INDEXING, new Object[0]);
            }
        }
        try {
            if (!this.isWritable(state2)) return result2;
            Object newObject = result2.getTypeDescriptor().getType().newInstance();
            this.writeProperty(state2, this.name, newObject);
            return this.readProperty(state2, this.name);
        }
        catch (InstantiationException ex6) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex6, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result2.getTypeDescriptor().getType());
        }
        catch (IllegalAccessException ex7) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex7, SpelMessage.UNABLE_TO_DYNAMICALLY_CREATE_OBJECT, result2.getTypeDescriptor().getType());
        }
    }

    @Override
    public void setValue(ExpressionState state2, Object newValue) throws SpelEvaluationException {
        this.writeProperty(state2, this.name, newValue);
    }

    @Override
    public boolean isWritable(ExpressionState state2) throws SpelEvaluationException {
        return this.isWritableProperty(this.name, state2);
    }

    @Override
    public String toStringAST() {
        return this.name;
    }

    private TypedValue readProperty(ExpressionState state2, String name) throws EvaluationException {
        TypedValue contextObject = state2.getActiveContextObject();
        Object targetObject = contextObject.getValue();
        if (targetObject == null && this.nullSafe) {
            return TypedValue.NULL;
        }
        PropertyAccessor accessorToUse = this.cachedReadAccessor;
        if (accessorToUse != null) {
            try {
                return accessorToUse.read(state2.getEvaluationContext(), contextObject.getValue(), name);
            }
            catch (AccessException accessException) {
                this.cachedReadAccessor = null;
            }
        }
        Class<?> contextObjectClass = this.getObjectClass(contextObject.getValue());
        List<PropertyAccessor> accessorsToTry = this.getPropertyAccessorsToTry(contextObjectClass, state2);
        EvaluationContext eContext = state2.getEvaluationContext();
        if (accessorsToTry != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canRead(eContext, contextObject.getValue(), name)) continue;
                    if (accessor instanceof ReflectivePropertyAccessor) {
                        accessor = ((ReflectivePropertyAccessor)accessor).createOptimalAccessor(eContext, contextObject.getValue(), name);
                    }
                    this.cachedReadAccessor = accessor;
                    return accessor.read(eContext, contextObject.getValue(), name);
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(ae, SpelMessage.EXCEPTION_DURING_PROPERTY_READ, name, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE_ON_NULL, name);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE, name, FormatHelper.formatClassNameForMessage(contextObjectClass));
    }

    private void writeProperty(ExpressionState state2, String name, Object newValue) throws SpelEvaluationException {
        Class<?> contextObjectClass;
        List<PropertyAccessor> accessorsToTry;
        TypedValue contextObject = state2.getActiveContextObject();
        EvaluationContext eContext = state2.getEvaluationContext();
        if (contextObject.getValue() == null && this.nullSafe) {
            return;
        }
        PropertyAccessor accessorToUse = this.cachedWriteAccessor;
        if (accessorToUse != null) {
            try {
                accessorToUse.write(state2.getEvaluationContext(), contextObject.getValue(), name, newValue);
                return;
            }
            catch (AccessException accessException) {
                this.cachedWriteAccessor = null;
            }
        }
        if ((accessorsToTry = this.getPropertyAccessorsToTry(contextObjectClass = this.getObjectClass(contextObject.getValue()), state2)) != null) {
            try {
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canWrite(eContext, contextObject.getValue(), name)) continue;
                    this.cachedWriteAccessor = accessor;
                    accessor.write(eContext, contextObject.getValue(), name, newValue);
                    return;
                }
            }
            catch (AccessException ae) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ae, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, name, ae.getMessage());
            }
        }
        if (contextObject.getValue() == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE_ON_NULL, name);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE, name, FormatHelper.formatClassNameForMessage(contextObjectClass));
    }

    public boolean isWritableProperty(String name, ExpressionState state2) throws SpelEvaluationException {
        Object contextObject = state2.getActiveContextObject().getValue();
        EvaluationContext eContext = state2.getEvaluationContext();
        List<PropertyAccessor> resolversToTry = this.getPropertyAccessorsToTry(this.getObjectClass(contextObject), state2);
        if (resolversToTry != null) {
            for (PropertyAccessor pfResolver : resolversToTry) {
                try {
                    if (!pfResolver.canWrite(eContext, contextObject, name)) continue;
                    return true;
                }
                catch (AccessException accessException) {}
            }
        }
        return false;
    }

    private List<PropertyAccessor> getPropertyAccessorsToTry(Class<?> targetType, ExpressionState state2) {
        ArrayList<PropertyAccessor> specificAccessors = new ArrayList<PropertyAccessor>();
        ArrayList<PropertyAccessor> generalAccessors = new ArrayList<PropertyAccessor>();
        block0: for (PropertyAccessor resolver2 : state2.getPropertyAccessors()) {
            Class[] targets = resolver2.getSpecificTargetClasses();
            if (targets == null) {
                generalAccessors.add(resolver2);
                continue;
            }
            if (targetType == null) continue;
            Class[] classArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz2 = classArray[n2];
                if (clazz2 == targetType) {
                    specificAccessors.add(resolver2);
                    continue block0;
                }
                if (clazz2.isAssignableFrom(targetType)) {
                    generalAccessors.add(resolver2);
                }
                ++n2;
            }
        }
        ArrayList<PropertyAccessor> resolvers = new ArrayList<PropertyAccessor>();
        resolvers.addAll(specificAccessors);
        generalAccessors.removeAll(specificAccessors);
        resolvers.addAll(generalAccessors);
        return resolvers;
    }
}

