/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class Selection
extends SpelNodeImpl {
    public static final int ALL = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean nullSafe2, int variant, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe2;
        this.variant = variant;
    }

    public TypedValue getValueInternal(ExpressionState state2) throws EvaluationException {
        TypedValue op = state2.getActiveContextObject();
        Object operand = op.getValue();
        SpelNodeImpl selectionCriteria = this.children[0];
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            HashMap result2 = new HashMap();
            Object lastKey = null;
            for (Map.Entry entry2 : mapdata.entrySet()) {
                try {
                    TypedValue kvpair = new TypedValue(entry2);
                    state2.pushActiveContextObject(kvpair);
                    Object o = selectionCriteria.getValueInternal(state2).getValue();
                    if (o instanceof Boolean) {
                        if (!((Boolean)o).booleanValue()) continue;
                        if (this.variant == 1) {
                            result2.put(entry2.getKey(), entry2.getValue());
                            TypedValue typedValue = new TypedValue(result2);
                            return typedValue;
                        }
                        result2.put(entry2.getKey(), entry2.getValue());
                        lastKey = entry2.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state2.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result2.size() == 0) {
                return new TypedValue(null);
            }
            if (this.variant == 2) {
                HashMap resultMap = new HashMap();
                Object lastValue = result2.get(lastKey);
                resultMap.put(lastKey, lastValue);
                return new TypedValue(resultMap);
            }
            return new TypedValue(result2);
        }
        if (operand instanceof Collection || ObjectUtils.isArray(operand)) {
            ArrayList data2 = new ArrayList();
            Collection c2 = operand instanceof Collection ? (Collection)operand : (Collection)Arrays.asList(ObjectUtils.toObjectArray(operand));
            data2.addAll(c2);
            ArrayList result3 = new ArrayList();
            int idx = 0;
            for (Object element2 : data2) {
                try {
                    state2.pushActiveContextObject(new TypedValue(element2));
                    state2.enterScope("index", idx);
                    Object o = selectionCriteria.getValueInternal(state2).getValue();
                    if (o instanceof Boolean) {
                        if (((Boolean)o).booleanValue()) {
                            if (this.variant == 1) {
                                TypedValue typedValue = new TypedValue(element2);
                                return typedValue;
                            }
                            result3.add(element2);
                        }
                    } else {
                        throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                    }
                    ++idx;
                }
                finally {
                    state2.exitScope();
                    state2.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result3.size() == 0) {
                return TypedValue.NULL;
            }
            if (this.variant == 2) {
                return new TypedValue(result3.get(result3.size() - 1));
            }
            if (operand instanceof Collection) {
                return new TypedValue(result3);
            }
            Class<?> elementType2 = ClassUtils.resolvePrimitiveIfNecessary(op.getTypeDescriptor().getElementTypeDescriptor().getType());
            Object resultArray = Array.newInstance(elementType2, result3.size());
            System.arraycopy(result3.toArray(), 0, resultArray, 0, result3.size());
            return new TypedValue(resultArray);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return TypedValue.NULL;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, operand.getClass().getName());
    }

    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        switch (this.variant) {
            case 0: {
                sb.append("?[");
                break;
            }
            case 1: {
                sb.append("^[");
                break;
            }
            case 2: {
                sb.append("$[");
            }
        }
        return sb.append(this.getChild(0).toStringAST()).append("]").toString();
    }
}

