/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TypeCode {
    OBJECT(Object.class),
    BOOLEAN(Boolean.TYPE),
    BYTE(Byte.TYPE),
    CHAR(Character.TYPE),
    SHORT(Short.TYPE),
    INT(Integer.TYPE),
    LONG(Long.TYPE),
    FLOAT(Float.TYPE),
    DOUBLE(Double.TYPE);

    private Class<?> type;

    private TypeCode(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public static TypeCode forName(String name) {
        String searchingFor = name.toUpperCase();
        TypeCode[] tcs = TypeCode.values();
        int i = 1;
        while (i < tcs.length) {
            if (tcs[i].name().equals(searchingFor)) {
                return tcs[i];
            }
            ++i;
        }
        return OBJECT;
    }

    public static TypeCode forClass(Class<?> c2) {
        TypeCode[] allValues = TypeCode.values();
        int i = 0;
        while (i < allValues.length) {
            TypeCode typeCode = allValues[i];
            if (c2 == typeCode.getType()) {
                return typeCode;
            }
            ++i;
        }
        return OBJECT;
    }
}

