/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    public TypedValue getValueInternal(ExpressionState state2) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return state2.getActiveContextObject();
        }
        if (this.name.equals(ROOT)) {
            return state2.getRootContextObject();
        }
        TypedValue result2 = state2.lookupVariable(this.name);
        return result2;
    }

    public void setValue(ExpressionState state2, Object value2) throws SpelEvaluationException {
        state2.setVariable(this.name, value2);
    }

    public String toStringAST() {
        return "#" + this.name;
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !this.name.equals(THIS) && !this.name.equals(ROOT);
    }
}

