/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.InternalParseException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.ast.Assign;
import org.springframework.expression.spel.ast.BeanReference;
import org.springframework.expression.spel.ast.BooleanLiteral;
import org.springframework.expression.spel.ast.CompoundExpression;
import org.springframework.expression.spel.ast.ConstructorReference;
import org.springframework.expression.spel.ast.Elvis;
import org.springframework.expression.spel.ast.FunctionReference;
import org.springframework.expression.spel.ast.Identifier;
import org.springframework.expression.spel.ast.Indexer;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.MethodReference;
import org.springframework.expression.spel.ast.NullLiteral;
import org.springframework.expression.spel.ast.OpAnd;
import org.springframework.expression.spel.ast.OpDivide;
import org.springframework.expression.spel.ast.OpEQ;
import org.springframework.expression.spel.ast.OpGE;
import org.springframework.expression.spel.ast.OpGT;
import org.springframework.expression.spel.ast.OpLE;
import org.springframework.expression.spel.ast.OpLT;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.OpModulus;
import org.springframework.expression.spel.ast.OpMultiply;
import org.springframework.expression.spel.ast.OpNE;
import org.springframework.expression.spel.ast.OpOr;
import org.springframework.expression.spel.ast.OpPlus;
import org.springframework.expression.spel.ast.OperatorBetween;
import org.springframework.expression.spel.ast.OperatorInstanceof;
import org.springframework.expression.spel.ast.OperatorMatches;
import org.springframework.expression.spel.ast.OperatorNot;
import org.springframework.expression.spel.ast.OperatorPower;
import org.springframework.expression.spel.ast.Projection;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.QualifiedIdentifier;
import org.springframework.expression.spel.ast.Selection;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.expression.spel.ast.Ternary;
import org.springframework.expression.spel.ast.TypeReference;
import org.springframework.expression.spel.ast.VariableReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.Token;
import org.springframework.expression.spel.standard.TokenKind;
import org.springframework.expression.spel.standard.Tokenizer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InternalSpelExpressionParser
extends TemplateAwareExpressionParser {
    private String expressionString;
    private List<Token> tokenStream;
    private int tokenStreamLength;
    private int tokenStreamPointer;
    private Stack<SpelNodeImpl> constructedNodes = new Stack();
    private SpelParserConfiguration configuration;

    public InternalSpelExpressionParser(SpelParserConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected SpelExpression doParseExpression(String expressionString, ParserContext context) throws ParseException {
        try {
            this.expressionString = expressionString;
            Tokenizer tokenizer = new Tokenizer(expressionString);
            tokenizer.process();
            this.tokenStream = tokenizer.getTokens();
            this.tokenStreamLength = this.tokenStream.size();
            this.tokenStreamPointer = 0;
            this.constructedNodes.clear();
            SpelNodeImpl ast = this.eatExpression();
            if (this.moreTokens()) {
                throw new SpelParseException(this.peekToken().startpos, SpelMessage.MORE_INPUT, this.toString(this.nextToken()));
            }
            Assert.isTrue(this.constructedNodes.isEmpty());
            return new SpelExpression(expressionString, ast, this.configuration);
        }
        catch (InternalParseException ipe) {
            throw ipe.getCause();
        }
    }

    private SpelNodeImpl eatExpression() {
        SpelNodeImpl expr2 = this.eatLogicalOrExpression();
        if (this.moreTokens()) {
            Token t2 = this.peekToken();
            if (t2.kind == TokenKind.ASSIGN) {
                if (expr2 == null) {
                    expr2 = new NullLiteral(this.toPos(t2.startpos - 1, t2.endpos - 1));
                }
                this.nextToken();
                SpelNodeImpl assignedValue = this.eatLogicalOrExpression();
                return new Assign(this.toPos(t2), expr2, assignedValue);
            }
            if (t2.kind == TokenKind.ELVIS) {
                if (expr2 == null) {
                    expr2 = new NullLiteral(this.toPos(t2.startpos - 1, t2.endpos - 2));
                }
                this.nextToken();
                SpelNodeImpl valueIfNull = this.eatExpression();
                if (valueIfNull == null) {
                    valueIfNull = new NullLiteral(this.toPos(t2.startpos + 1, t2.endpos + 1));
                }
                return new Elvis(this.toPos(t2), expr2, valueIfNull);
            }
            if (t2.kind == TokenKind.QMARK) {
                if (expr2 == null) {
                    expr2 = new NullLiteral(this.toPos(t2.startpos - 1, t2.endpos - 1));
                }
                this.nextToken();
                SpelNodeImpl ifTrueExprValue = this.eatExpression();
                this.eatToken(TokenKind.COLON);
                SpelNodeImpl ifFalseExprValue = this.eatExpression();
                return new Ternary(this.toPos(t2), expr2, ifTrueExprValue, ifFalseExprValue);
            }
        }
        return expr2;
    }

    private SpelNodeImpl eatLogicalOrExpression() {
        SpelNodeImpl expr2 = this.eatLogicalAndExpression();
        while (this.peekIdentifierToken("or")) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatLogicalAndExpression();
            this.checkRightOperand(t2, rhExpr);
            expr2 = new OpOr(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatLogicalAndExpression() {
        SpelNodeImpl expr2 = this.eatRelationalExpression();
        while (this.peekIdentifierToken("and")) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatRelationalExpression();
            this.checkRightOperand(t2, rhExpr);
            expr2 = new OpAnd(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatRelationalExpression() {
        SpelNodeImpl expr2 = this.eatSumExpression();
        Token relationalOperatorToken = this.maybeEatRelationalOperator();
        if (relationalOperatorToken != null) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatSumExpression();
            this.checkRightOperand(t2, rhExpr);
            TokenKind tk = relationalOperatorToken.kind;
            if (relationalOperatorToken.isNumericRelationalOperator()) {
                int pos = this.toPos(t2);
                if (tk == TokenKind.GT) {
                    return new OpGT(pos, expr2, rhExpr);
                }
                if (tk == TokenKind.LT) {
                    return new OpLT(pos, expr2, rhExpr);
                }
                if (tk == TokenKind.LE) {
                    return new OpLE(pos, expr2, rhExpr);
                }
                if (tk == TokenKind.GE) {
                    return new OpGE(pos, expr2, rhExpr);
                }
                if (tk == TokenKind.EQ) {
                    return new OpEQ(pos, expr2, rhExpr);
                }
                Assert.isTrue(tk == TokenKind.NE);
                return new OpNE(pos, expr2, rhExpr);
            }
            if (tk == TokenKind.INSTANCEOF) {
                return new OperatorInstanceof(this.toPos(t2), expr2, rhExpr);
            }
            if (tk == TokenKind.MATCHES) {
                return new OperatorMatches(this.toPos(t2), expr2, rhExpr);
            }
            Assert.isTrue(tk == TokenKind.BETWEEN);
            return new OperatorBetween(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatSumExpression() {
        SpelNodeImpl expr2 = this.eatProductExpression();
        while (this.peekToken(TokenKind.PLUS, TokenKind.MINUS)) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatProductExpression();
            this.checkRightOperand(t2, rhExpr);
            if (t2.kind == TokenKind.PLUS) {
                expr2 = new OpPlus(this.toPos(t2), expr2, rhExpr);
                continue;
            }
            Assert.isTrue(t2.kind == TokenKind.MINUS);
            expr2 = new OpMinus(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatProductExpression() {
        SpelNodeImpl expr2 = this.eatPowerExpression();
        while (this.peekToken(TokenKind.STAR, TokenKind.DIV, TokenKind.MOD)) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatPowerExpression();
            this.checkRightOperand(t2, rhExpr);
            if (t2.kind == TokenKind.STAR) {
                expr2 = new OpMultiply(this.toPos(t2), expr2, rhExpr);
                continue;
            }
            if (t2.kind == TokenKind.DIV) {
                expr2 = new OpDivide(this.toPos(t2), expr2, rhExpr);
                continue;
            }
            Assert.isTrue(t2.kind == TokenKind.MOD);
            expr2 = new OpModulus(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatPowerExpression() {
        SpelNodeImpl expr2 = this.eatUnaryExpression();
        if (this.peekToken(TokenKind.POWER)) {
            Token t2 = this.nextToken();
            SpelNodeImpl rhExpr = this.eatUnaryExpression();
            this.checkRightOperand(t2, rhExpr);
            return new OperatorPower(this.toPos(t2), expr2, rhExpr);
        }
        return expr2;
    }

    private SpelNodeImpl eatUnaryExpression() {
        if (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.NOT)) {
            Token t2 = this.nextToken();
            SpelNodeImpl expr2 = this.eatUnaryExpression();
            if (t2.kind == TokenKind.NOT) {
                return new OperatorNot(this.toPos(t2), expr2);
            }
            if (t2.kind == TokenKind.PLUS) {
                return new OpPlus(this.toPos(t2), expr2);
            }
            Assert.isTrue(t2.kind == TokenKind.MINUS);
            return new OpMinus(this.toPos(t2), expr2);
        }
        return this.eatPrimaryExpression();
    }

    private SpelNodeImpl eatPrimaryExpression() {
        ArrayList<SpelNodeImpl> nodes2 = new ArrayList<SpelNodeImpl>();
        SpelNodeImpl start2 = this.eatStartNode();
        nodes2.add(start2);
        while (this.maybeEatNode()) {
            nodes2.add(this.pop());
        }
        if (nodes2.size() == 1) {
            return (SpelNodeImpl)nodes2.get(0);
        }
        return new CompoundExpression(this.toPos(start2.getStartPosition(), ((SpelNodeImpl)nodes2.get(nodes2.size() - 1)).getEndPosition()), nodes2.toArray(new SpelNodeImpl[nodes2.size()]));
    }

    private boolean maybeEatNode() {
        SpelNodeImpl expr2 = null;
        expr2 = this.peekToken(TokenKind.DOT, TokenKind.SAFE_NAVI) ? this.eatDottedNode() : this.maybeEatNonDottedNode();
        if (expr2 == null) {
            return false;
        }
        this.push(expr2);
        return true;
    }

    private SpelNodeImpl maybeEatNonDottedNode() {
        if (this.peekToken(TokenKind.LSQUARE) && this.maybeEatIndexer()) {
            return this.pop();
        }
        return null;
    }

    private SpelNodeImpl eatDottedNode() {
        boolean nullSafeNavigation;
        Token t2 = this.nextToken();
        boolean bl = nullSafeNavigation = t2.kind == TokenKind.SAFE_NAVI;
        if (this.maybeEatMethodOrProperty(nullSafeNavigation) || this.maybeEatFunctionOrVar() || this.maybeEatProjection(nullSafeNavigation) || this.maybeEatSelection(nullSafeNavigation)) {
            return this.pop();
        }
        if (this.peekToken() == null) {
            this.raiseInternalException(t2.startpos, SpelMessage.OOD, new Object[0]);
        } else {
            this.raiseInternalException(t2.startpos, SpelMessage.UNEXPECTED_DATA_AFTER_DOT, this.toString(this.peekToken()));
        }
        return null;
    }

    private boolean maybeEatFunctionOrVar() {
        if (!this.peekToken(TokenKind.HASH)) {
            return false;
        }
        Token t2 = this.nextToken();
        Token functionOrVariableName = this.eatToken(TokenKind.IDENTIFIER);
        SpelNodeImpl[] args2 = this.maybeEatMethodArgs();
        if (args2 == null) {
            this.push(new VariableReference(functionOrVariableName.data, this.toPos(t2.startpos, functionOrVariableName.endpos)));
            return true;
        }
        this.push(new FunctionReference(functionOrVariableName.data, this.toPos(t2.startpos, functionOrVariableName.endpos), args2));
        return true;
    }

    private SpelNodeImpl[] maybeEatMethodArgs() {
        if (!this.peekToken(TokenKind.LPAREN)) {
            return null;
        }
        ArrayList<SpelNodeImpl> args2 = new ArrayList<SpelNodeImpl>();
        this.consumeArguments(args2);
        this.eatToken(TokenKind.RPAREN);
        return args2.toArray(new SpelNodeImpl[args2.size()]);
    }

    private void eatConstructorArgs(List<SpelNodeImpl> accumulatedArguments) {
        if (!this.peekToken(TokenKind.LPAREN)) {
            throw new InternalParseException(new SpelParseException(this.expressionString, this.positionOf(this.peekToken()), SpelMessage.MISSING_CONSTRUCTOR_ARGS, new Object[0]));
        }
        this.consumeArguments(accumulatedArguments);
        this.eatToken(TokenKind.RPAREN);
    }

    private void consumeArguments(List<SpelNodeImpl> accumulatedArguments) {
        int pos = this.peekToken().startpos;
        Token next2 = null;
        do {
            this.nextToken();
            Token t2 = this.peekToken();
            if (t2 == null) {
                this.raiseInternalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
            }
            if (t2.kind == TokenKind.RPAREN) continue;
            accumulatedArguments.add(this.eatExpression());
        } while ((next2 = this.peekToken()) != null && next2.kind == TokenKind.COMMA);
        if (next2 == null) {
            this.raiseInternalException(pos, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
        }
    }

    private int positionOf(Token t2) {
        if (t2 == null) {
            return this.expressionString.length();
        }
        return t2.startpos;
    }

    private SpelNodeImpl eatStartNode() {
        if (this.maybeEatLiteral()) {
            return this.pop();
        }
        if (this.maybeEatParenExpression()) {
            return this.pop();
        }
        if (this.maybeEatTypeReference() || this.maybeEatNullReference() || this.maybeEatConstructorReference() || this.maybeEatMethodOrProperty(false) || this.maybeEatFunctionOrVar()) {
            return this.pop();
        }
        if (this.maybeEatBeanReference()) {
            return this.pop();
        }
        if (this.maybeEatProjection(false) || this.maybeEatSelection(false) || this.maybeEatIndexer()) {
            return this.pop();
        }
        if (this.maybeEatInlineList()) {
            return this.pop();
        }
        return null;
    }

    private boolean maybeEatBeanReference() {
        if (this.peekToken(TokenKind.BEAN_REF)) {
            Token beanRefToken = this.nextToken();
            Token beanNameToken = null;
            String beanname = null;
            if (this.peekToken(TokenKind.IDENTIFIER)) {
                beanNameToken = this.eatToken(TokenKind.IDENTIFIER);
                beanname = beanNameToken.data;
            } else if (this.peekToken(TokenKind.LITERAL_STRING)) {
                beanNameToken = this.eatToken(TokenKind.LITERAL_STRING);
                beanname = beanNameToken.stringValue();
                beanname = beanname.substring(1, beanname.length() - 1);
            } else {
                this.raiseInternalException(beanRefToken.startpos, SpelMessage.INVALID_BEAN_REFERENCE, new Object[0]);
            }
            BeanReference beanReference = new BeanReference(this.toPos(beanNameToken), beanname);
            this.constructedNodes.push(beanReference);
            return true;
        }
        return false;
    }

    private boolean maybeEatTypeReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token typeName = this.peekToken();
            if (!typeName.stringValue().equals("T")) {
                return false;
            }
            this.nextToken();
            this.eatToken(TokenKind.LPAREN);
            SpelNodeImpl node4 = this.eatPossiblyQualifiedId();
            this.eatToken(TokenKind.RPAREN);
            this.constructedNodes.push(new TypeReference(this.toPos(typeName), node4));
            return true;
        }
        return false;
    }

    private boolean maybeEatNullReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token nullToken = this.peekToken();
            if (!nullToken.stringValue().equals("null")) {
                return false;
            }
            this.nextToken();
            this.constructedNodes.push(new NullLiteral(this.toPos(nullToken)));
            return true;
        }
        return false;
    }

    private boolean maybeEatProjection(boolean nullSafeNavigation) {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.PROJECT, true)) {
            return false;
        }
        SpelNodeImpl expr2 = this.eatExpression();
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Projection(nullSafeNavigation, this.toPos(t2), expr2));
        return true;
    }

    private boolean maybeEatInlineList() {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.LCURLY, true)) {
            return false;
        }
        InlineList expr2 = null;
        Token closingCurly = this.peekToken();
        if (this.peekToken(TokenKind.RCURLY, true)) {
            expr2 = new InlineList(this.toPos(t2.startpos, closingCurly.endpos), new SpelNodeImpl[0]);
        } else {
            ArrayList<SpelNodeImpl> listElements = new ArrayList<SpelNodeImpl>();
            do {
                listElements.add(this.eatExpression());
            } while (this.peekToken(TokenKind.COMMA, true));
            closingCurly = this.eatToken(TokenKind.RCURLY);
            expr2 = new InlineList(this.toPos(t2.startpos, closingCurly.endpos), listElements.toArray(new SpelNodeImpl[listElements.size()]));
        }
        this.constructedNodes.push(expr2);
        return true;
    }

    private boolean maybeEatIndexer() {
        Token t2 = this.peekToken();
        if (!this.peekToken(TokenKind.LSQUARE, true)) {
            return false;
        }
        SpelNodeImpl expr2 = this.eatExpression();
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Indexer(this.toPos(t2), expr2));
        return true;
    }

    private boolean maybeEatSelection(boolean nullSafeNavigation) {
        Token t2 = this.peekToken();
        if (!this.peekSelectToken()) {
            return false;
        }
        this.nextToken();
        SpelNodeImpl expr2 = this.eatExpression();
        this.eatToken(TokenKind.RSQUARE);
        if (t2.kind == TokenKind.SELECT_FIRST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 1, this.toPos(t2), expr2));
        } else if (t2.kind == TokenKind.SELECT_LAST) {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 2, this.toPos(t2), expr2));
        } else {
            this.constructedNodes.push(new Selection(nullSafeNavigation, 0, this.toPos(t2), expr2));
        }
        return true;
    }

    private SpelNodeImpl eatPossiblyQualifiedId() {
        ArrayList<Identifier> qualifiedIdPieces = new ArrayList<Identifier>();
        Token startnode = this.eatToken(TokenKind.IDENTIFIER);
        qualifiedIdPieces.add(new Identifier(startnode.stringValue(), this.toPos(startnode)));
        while (this.peekToken(TokenKind.DOT, true)) {
            Token node4 = this.eatToken(TokenKind.IDENTIFIER);
            qualifiedIdPieces.add(new Identifier(node4.stringValue(), this.toPos(node4)));
        }
        return new QualifiedIdentifier(this.toPos(startnode.startpos, ((SpelNodeImpl)qualifiedIdPieces.get(qualifiedIdPieces.size() - 1)).getEndPosition()), qualifiedIdPieces.toArray(new SpelNodeImpl[qualifiedIdPieces.size()]));
    }

    private boolean maybeEatMethodOrProperty(boolean nullSafeNavigation) {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token methodOrPropertyName = this.nextToken();
            SpelNodeImpl[] args2 = this.maybeEatMethodArgs();
            if (args2 == null) {
                this.push(new PropertyOrFieldReference(nullSafeNavigation, methodOrPropertyName.data, this.toPos(methodOrPropertyName)));
                return true;
            }
            this.push(new MethodReference(nullSafeNavigation, methodOrPropertyName.data, this.toPos(methodOrPropertyName), args2));
            return true;
        }
        return false;
    }

    private boolean maybeEatConstructorReference() {
        if (this.peekIdentifierToken("new")) {
            Token newToken = this.nextToken();
            SpelNodeImpl possiblyQualifiedConstructorName = this.eatPossiblyQualifiedId();
            ArrayList<SpelNodeImpl> nodes2 = new ArrayList<SpelNodeImpl>();
            nodes2.add(possiblyQualifiedConstructorName);
            if (this.peekToken(TokenKind.LSQUARE)) {
                ArrayList<SpelNodeImpl> dimensions = new ArrayList<SpelNodeImpl>();
                while (this.peekToken(TokenKind.LSQUARE, true)) {
                    if (!this.peekToken(TokenKind.RSQUARE)) {
                        dimensions.add(this.eatExpression());
                    } else {
                        dimensions.add(null);
                    }
                    this.eatToken(TokenKind.RSQUARE);
                }
                if (this.maybeEatInlineList()) {
                    nodes2.add(this.pop());
                }
                this.push(new ConstructorReference(this.toPos(newToken), dimensions.toArray(new SpelNodeImpl[dimensions.size()]), nodes2.toArray(new SpelNodeImpl[nodes2.size()])));
            } else {
                this.eatConstructorArgs(nodes2);
                this.push(new ConstructorReference(this.toPos(newToken), nodes2.toArray(new SpelNodeImpl[nodes2.size()])));
            }
            return true;
        }
        return false;
    }

    private void push(SpelNodeImpl newNode) {
        this.constructedNodes.push(newNode);
    }

    private SpelNodeImpl pop() {
        return this.constructedNodes.pop();
    }

    private boolean maybeEatLiteral() {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return false;
        }
        if (t2.kind == TokenKind.LITERAL_INT) {
            this.push(Literal.getIntLiteral(t2.data, this.toPos(t2), 10));
        } else if (t2.kind == TokenKind.LITERAL_LONG) {
            this.push(Literal.getLongLiteral(t2.data, this.toPos(t2), 10));
        } else if (t2.kind == TokenKind.LITERAL_HEXINT) {
            this.push(Literal.getIntLiteral(t2.data, this.toPos(t2), 16));
        } else if (t2.kind == TokenKind.LITERAL_HEXLONG) {
            this.push(Literal.getLongLiteral(t2.data, this.toPos(t2), 16));
        } else if (t2.kind == TokenKind.LITERAL_REAL) {
            this.push(Literal.getRealLiteral(t2.data, this.toPos(t2), false));
        } else if (t2.kind == TokenKind.LITERAL_REAL_FLOAT) {
            this.push(Literal.getRealLiteral(t2.data, this.toPos(t2), true));
        } else if (this.peekIdentifierToken("true")) {
            this.push(new BooleanLiteral(t2.data, this.toPos(t2), true));
        } else if (this.peekIdentifierToken("false")) {
            this.push(new BooleanLiteral(t2.data, this.toPos(t2), false));
        } else if (t2.kind == TokenKind.LITERAL_STRING) {
            this.push(new StringLiteral(t2.data, this.toPos(t2), t2.data));
        } else {
            return false;
        }
        this.nextToken();
        return true;
    }

    private boolean maybeEatParenExpression() {
        if (this.peekToken(TokenKind.LPAREN)) {
            this.nextToken();
            SpelNodeImpl expr2 = this.eatExpression();
            this.eatToken(TokenKind.RPAREN);
            this.push(expr2);
            return true;
        }
        return false;
    }

    private Token maybeEatRelationalOperator() {
        Token t2 = this.peekToken();
        if (t2 == null) {
            return null;
        }
        if (t2.isNumericRelationalOperator()) {
            return t2;
        }
        if (t2.isIdentifier()) {
            String idString = t2.stringValue();
            if (idString.equalsIgnoreCase("instanceof")) {
                return t2.asInstanceOfToken();
            }
            if (idString.equalsIgnoreCase("matches")) {
                return t2.asMatchesToken();
            }
            if (idString.equalsIgnoreCase("between")) {
                return t2.asBetweenToken();
            }
        }
        return null;
    }

    private Token eatToken(TokenKind expectedKind) {
        Token t2 = this.nextToken();
        if (t2 == null) {
            this.raiseInternalException(this.expressionString.length(), SpelMessage.OOD, new Object[0]);
        }
        if (t2.kind != expectedKind) {
            this.raiseInternalException(t2.startpos, SpelMessage.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t2.getKind().toString().toLowerCase());
        }
        return t2;
    }

    private boolean peekToken(TokenKind desiredTokenKind) {
        return this.peekToken(desiredTokenKind, false);
    }

    private boolean peekToken(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t2 = this.peekToken();
        if (t2.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.tokenStreamPointer;
            }
            return true;
        }
        return desiredTokenKind == TokenKind.IDENTIFIER && t2.kind.ordinal() >= TokenKind.DIV.ordinal() && t2.kind.ordinal() <= TokenKind.NOT.ordinal() && t2.data != null;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t2 = this.peekToken();
        return t2.kind == possible1 || t2.kind == possible2;
    }

    private boolean peekToken(TokenKind possible1, TokenKind possible2, TokenKind possible3) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t2 = this.peekToken();
        return t2.kind == possible1 || t2.kind == possible2 || t2.kind == possible3;
    }

    private boolean peekIdentifierToken(String identifierString) {
        if (!this.moreTokens()) {
            return false;
        }
        Token t2 = this.peekToken();
        return t2.kind == TokenKind.IDENTIFIER && t2.stringValue().equalsIgnoreCase(identifierString);
    }

    private boolean peekSelectToken() {
        if (!this.moreTokens()) {
            return false;
        }
        Token t2 = this.peekToken();
        return t2.kind == TokenKind.SELECT || t2.kind == TokenKind.SELECT_FIRST || t2.kind == TokenKind.SELECT_LAST;
    }

    private boolean moreTokens() {
        return this.tokenStreamPointer < this.tokenStream.size();
    }

    private Token nextToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token peekToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer);
    }

    private void raiseInternalException(int pos, SpelMessage message, Object ... inserts) {
        throw new InternalParseException(new SpelParseException(this.expressionString, pos, message, inserts));
    }

    public String toString(Token t2) {
        if (t2.getKind().hasPayload()) {
            return t2.stringValue();
        }
        return t2.kind.toString().toLowerCase();
    }

    private void checkRightOperand(Token token2, SpelNodeImpl operandExpression) {
        if (operandExpression == null) {
            this.raiseInternalException(token2.startpos, SpelMessage.RIGHT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private int toPos(Token t2) {
        return (t2.startpos << 16) + t2.endpos;
    }

    private int toPos(int start2, int end2) {
        return (start2 << 16) + end2;
    }
}

