/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Constructor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectiveConstructorExecutor
implements ConstructorExecutor {
    private final Constructor<?> ctor;
    private final Integer varargsPosition;
    private final int[] argsRequiringConversion;

    public ReflectiveConstructorExecutor(Constructor<?> ctor, int[] argsRequiringConversion) {
        this.ctor = ctor;
        if (ctor.isVarArgs()) {
            Class<?>[] paramTypes2 = ctor.getParameterTypes();
            this.varargsPosition = paramTypes2.length - 1;
        } else {
            this.varargsPosition = null;
        }
        this.argsRequiringConversion = argsRequiringConversion;
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object ... arguments2) throws AccessException {
        try {
            if (arguments2 != null) {
                ReflectionHelper.convertArguments(context.getTypeConverter(), arguments2, this.ctor, this.argsRequiringConversion, this.varargsPosition);
            }
            if (this.ctor.isVarArgs()) {
                arguments2 = ReflectionHelper.setupArgumentsForVarargsInvocation(this.ctor.getParameterTypes(), arguments2);
            }
            ReflectionUtils.makeAccessible(this.ctor);
            return new TypedValue(this.ctor.newInstance(arguments2));
        }
        catch (Exception ex2) {
            throw new AccessException("Problem invoking constructor: " + this.ctor, ex2);
        }
    }
}

