/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

class ReflectiveMethodExecutor
implements MethodExecutor {
    private final Method method;
    private final Integer varargsPosition;
    private final int[] argsRequiringConversion;

    public ReflectiveMethodExecutor(Method theMethod, int[] argumentsRequiringConversion) {
        this.method = theMethod;
        if (theMethod.isVarArgs()) {
            Class<?>[] paramTypes2 = theMethod.getParameterTypes();
            this.varargsPosition = paramTypes2.length - 1;
        } else {
            this.varargsPosition = null;
        }
        this.argsRequiringConversion = argumentsRequiringConversion;
    }

    public TypedValue execute(EvaluationContext context, Object target2, Object ... arguments2) throws AccessException {
        try {
            if (arguments2 != null) {
                ReflectionHelper.convertArguments(context.getTypeConverter(), arguments2, this.method, this.argsRequiringConversion, this.varargsPosition);
            }
            if (this.method.isVarArgs()) {
                arguments2 = ReflectionHelper.setupArgumentsForVarargsInvocation(this.method.getParameterTypes(), arguments2);
            }
            ReflectionUtils.makeAccessible(this.method);
            Object value2 = this.method.invoke(target2, arguments2);
            return new TypedValue(value2, new TypeDescriptor(new MethodParameter(this.method, -1)).narrow(value2));
        }
        catch (Exception ex2) {
            throw new AccessException("Problem invoking method: " + this.method, ex2);
        }
    }
}

