/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import org.springframework.expression.TypeComparator;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;

public class StandardTypeComparator
implements TypeComparator {
    public int compare(Object left2, Object right2) throws SpelEvaluationException {
        if (left2 == null) {
            return right2 == null ? 0 : -1;
        }
        if (right2 == null) {
            return 1;
        }
        if (left2 instanceof Number && right2 instanceof Number) {
            Number leftNumber = (Number)left2;
            Number rightNumber = (Number)right2;
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                double d1 = leftNumber.doubleValue();
                double d2 = rightNumber.doubleValue();
                return Double.compare(d1, d2);
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                float f1 = leftNumber.floatValue();
                float f2 = rightNumber.floatValue();
                return Float.compare(f1, f2);
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                Long l1 = leftNumber.longValue();
                Long l2 = rightNumber.longValue();
                return l1.compareTo(l2);
            }
            Integer i1 = leftNumber.intValue();
            Integer i2 = rightNumber.intValue();
            return i1.compareTo(i2);
        }
        try {
            if (left2 instanceof Comparable) {
                return ((Comparable)left2).compareTo(right2);
            }
        }
        catch (ClassCastException cce) {
            throw new SpelEvaluationException(cce, SpelMessage.NOT_COMPARABLE, left2.getClass(), right2.getClass());
        }
        throw new SpelEvaluationException(SpelMessage.NOT_COMPARABLE, left2.getClass(), right2.getClass());
    }

    public boolean canCompare(Object left2, Object right2) {
        if (left2 == null || right2 == null) {
            return true;
        }
        if (left2 instanceof Number && right2 instanceof Number) {
            return true;
        }
        return left2 instanceof Comparable;
    }
}

