/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.springframework.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberFormatter
implements Formatter<Number> {
    private boolean lenient = false;

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    @Override
    public String print(Number number2, Locale locale) {
        return this.getNumberFormat(locale).format(number2);
    }

    @Override
    public Number parse(String text2, Locale locale) throws ParseException {
        NumberFormat format2 = this.getNumberFormat(locale);
        ParsePosition position2 = new ParsePosition(0);
        Number number2 = format2.parse(text2, position2);
        if (position2.getErrorIndex() != -1) {
            throw new ParseException(text2, position2.getIndex());
        }
        if (!this.lenient && text2.length() != position2.getIndex()) {
            throw new ParseException(text2, position2.getIndex());
        }
        return number2;
    }

    protected abstract NumberFormat getNumberFormat(Locale var1);
}

