/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import org.springframework.format.number.AbstractNumberFormatter;
import org.springframework.util.ClassUtils;

public class CurrencyFormatter
extends AbstractNumberFormatter {
    private static final boolean roundingModeOnDecimalFormat = ClassUtils.hasMethod(DecimalFormat.class, "setRoundingMode", RoundingMode.class);
    private int fractionDigits = 2;
    private RoundingMode roundingMode;
    private Currency currency;

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal parse(String text2, Locale locale) throws ParseException {
        BigDecimal decimal = (BigDecimal)super.parse(text2, locale);
        if (decimal != null) {
            decimal = this.roundingMode != null ? decimal.setScale(this.fractionDigits, this.roundingMode) : decimal.setScale(this.fractionDigits);
        }
        return decimal;
    }

    protected NumberFormat getNumberFormat(Locale locale) {
        DecimalFormat format2 = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        format2.setParseBigDecimal(true);
        format2.setMaximumFractionDigits(this.fractionDigits);
        format2.setMinimumFractionDigits(this.fractionDigits);
        if (this.roundingMode != null && roundingModeOnDecimalFormat) {
            format2.setRoundingMode(this.roundingMode);
        }
        if (this.currency != null) {
            format2.setCurrency(this.currency);
        }
        return format2;
    }
}

