/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEntity<T> {
    public static final HttpEntity EMPTY = new HttpEntity();
    private final HttpHeaders headers;
    private final T body;

    protected HttpEntity() {
        this(null, null);
    }

    public HttpEntity(T body2) {
        this(body2, null);
    }

    public HttpEntity(MultiValueMap<String, String> headers2) {
        this(null, headers2);
    }

    public HttpEntity(T body2, MultiValueMap<String, String> headers2) {
        this.body = body2;
        HttpHeaders tempHeaders = new HttpHeaders();
        if (headers2 != null) {
            tempHeaders.putAll((Map<? extends String, ? extends List<String>>)headers2);
        }
        this.headers = HttpHeaders.readOnlyHttpHeaders(tempHeaders);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        if (this.body != null) {
            builder.append(this.body);
            if (this.headers != null) {
                builder.append(',');
            }
        }
        if (this.headers != null) {
            builder.append(this.headers);
        }
        builder.append('>');
        return builder.toString();
    }
}

