/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseEntity<T>
extends HttpEntity<T> {
    private final HttpStatus statusCode;

    public ResponseEntity(HttpStatus statusCode) {
        this.statusCode = statusCode;
    }

    public ResponseEntity(T body2, HttpStatus statusCode) {
        super(body2);
        this.statusCode = statusCode;
    }

    public ResponseEntity(MultiValueMap<String, String> headers2, HttpStatus statusCode) {
        super(headers2);
        this.statusCode = statusCode;
    }

    public ResponseEntity(T body2, MultiValueMap<String, String> headers2, HttpStatus statusCode) {
        super(body2, headers2);
        this.statusCode = statusCode;
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.statusCode.toString());
        builder.append(' ');
        builder.append(this.statusCode.getReasonPhrase());
        builder.append(',');
        Object body2 = this.getBody();
        HttpHeaders headers2 = this.getHeaders();
        if (body2 != null) {
            builder.append(body2);
            if (headers2 != null) {
                builder.append(',');
            }
        }
        if (headers2 != null) {
            builder.append(headers2);
        }
        builder.append('>');
        return builder.toString();
    }
}

