/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

abstract class AbstractBufferingClientHttpRequest
extends AbstractClientHttpRequest {
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream();

    AbstractBufferingClientHttpRequest() {
    }

    protected OutputStream getBodyInternal(HttpHeaders headers2) throws IOException {
        return this.bufferedOutput;
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers2) throws IOException {
        byte[] bytes2 = this.bufferedOutput.toByteArray();
        if (headers2.getContentLength() == -1L) {
            headers2.setContentLength(bytes2.length);
        }
        ClientHttpResponse result2 = this.executeInternal(headers2, bytes2);
        this.bufferedOutput = null;
        return result2;
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, byte[] var2) throws IOException;
}

