/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingClientHttpRequest;
import org.springframework.http.client.BufferingClientHttpResponseWrapper;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

final class BufferingClientHttpRequestWrapper
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequestWrapper(ClientHttpRequest request) {
        Assert.notNull(request, "'request' must not be null");
        this.request = request;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers2, byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll(headers2);
        OutputStream body2 = this.request.getBody();
        FileCopyUtils.copy(bufferedOutput, body2);
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponseWrapper(response);
    }
}

