/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.util.FileCopyUtils;

final class SimpleBufferingClientHttpRequest
extends AbstractBufferingClientHttpRequest {
    private final HttpURLConnection connection;

    SimpleBufferingClientHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex2) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex2.getMessage(), ex2);
        }
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers2, byte[] bufferedOutput) throws IOException {
        for (Map.Entry<String, List<String>> entry2 : headers2.entrySet()) {
            String headerName = entry2.getKey();
            for (String headerValue : entry2.getValue()) {
                this.connection.addRequestProperty(headerName, headerValue);
            }
        }
        if (this.connection.getDoOutput()) {
            this.connection.setFixedLengthStreamingMode(bufferedOutput.length);
        }
        this.connection.connect();
        if (this.connection.getDoOutput()) {
            FileCopyUtils.copy(bufferedOutput, this.connection.getOutputStream());
        }
        return new SimpleClientHttpResponse(this.connection);
    }
}

