/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;

final class SimpleStreamingClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpURLConnection connection;
    private final int chunkSize;
    private OutputStream body;

    SimpleStreamingClientHttpRequest(HttpURLConnection connection, int chunkSize) {
        this.connection = connection;
        this.chunkSize = chunkSize;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex2) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex2.getMessage(), ex2);
        }
    }

    protected OutputStream getBodyInternal(HttpHeaders headers2) throws IOException {
        if (this.body == null) {
            int contentLength = (int)headers2.getContentLength();
            if (contentLength >= 0) {
                this.connection.setFixedLengthStreamingMode(contentLength);
            } else {
                this.connection.setChunkedStreamingMode(this.chunkSize);
            }
            this.writeHeaders(headers2);
            this.connection.connect();
            this.body = this.connection.getOutputStream();
        }
        return new NonClosingOutputStream(this.body);
    }

    private void writeHeaders(HttpHeaders headers2) {
        for (Map.Entry<String, List<String>> entry2 : headers2.entrySet()) {
            String headerName = entry2.getKey();
            for (String headerValue : entry2.getValue()) {
                this.connection.addRequestProperty(headerName, headerValue);
            }
        }
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers2) throws IOException {
        try {
            if (this.body != null) {
                this.body.close();
            } else {
                this.writeHeaders(headers2);
                this.connection.connect();
            }
        }
        catch (IOException iOException) {}
        return new SimpleClientHttpResponse(this.connection);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        private NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
        }
    }
}

