/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpMessageConverter<T>
implements HttpMessageConverter<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private List<MediaType> supportedMediaTypes = Collections.emptyList();

    protected AbstractHttpMessageConverter() {
    }

    protected AbstractHttpMessageConverter(MediaType supportedMediaType) {
        this.setSupportedMediaTypes(Collections.singletonList(supportedMediaType));
    }

    protected AbstractHttpMessageConverter(MediaType ... supportedMediaTypes) {
        this.setSupportedMediaTypes(Arrays.asList(supportedMediaTypes));
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, "'supportedMediaTypes' must not be empty");
        this.supportedMediaTypes = new ArrayList<MediaType>(supportedMediaTypes);
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    @Override
    public boolean canRead(Class<?> clazz2, MediaType mediaType) {
        return this.supports(clazz2) && this.canRead(mediaType);
    }

    protected boolean canRead(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.includes(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(Class<?> clazz2, MediaType mediaType) {
        return this.supports(clazz2) && this.canWrite(mediaType);
    }

    protected boolean canWrite(MediaType mediaType) {
        if (mediaType == null || MediaType.ALL.equals(mediaType)) {
            return true;
        }
        for (MediaType supportedMediaType : this.getSupportedMediaTypes()) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final T read(Class<? extends T> clazz2, HttpInputMessage inputMessage) throws IOException {
        return this.readInternal(clazz2, inputMessage);
    }

    @Override
    public final void write(T t2, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Long contentLength;
        HttpHeaders headers2 = outputMessage.getHeaders();
        if (headers2.getContentType() == null) {
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = this.getDefaultContentType(t2);
            }
            if (contentType != null) {
                headers2.setContentType(contentType);
            }
        }
        if (headers2.getContentLength() == -1L && (contentLength = this.getContentLength(t2, headers2.getContentType())) != null) {
            headers2.setContentLength(contentLength);
        }
        this.writeInternal(t2, outputMessage);
        outputMessage.getBody().flush();
    }

    protected MediaType getDefaultContentType(T t2) throws IOException {
        List<MediaType> mediaTypes = this.getSupportedMediaTypes();
        return !mediaTypes.isEmpty() ? mediaTypes.get(0) : null;
    }

    protected Long getContentLength(T t2, MediaType contentType) throws IOException {
        return null;
    }

    protected abstract boolean supports(Class<?> var1);

    protected abstract T readInternal(Class<? extends T> var1, HttpInputMessage var2) throws IOException, HttpMessageNotReadableException;

    protected abstract void writeInternal(T var1, HttpOutputMessage var2) throws IOException, HttpMessageNotWritableException;
}

