/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxb2HttpMessageConverter<T>
extends AbstractXmlHttpMessageConverter<T> {
    private final ConcurrentMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap<Class, JAXBContext>();

    protected final Marshaller createMarshaller(Class clazz2) {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz2);
            return jaxbContext.createMarshaller();
        }
        catch (JAXBException ex2) {
            throw new HttpMessageConversionException("Could not create Marshaller for class [" + clazz2 + "]: " + ex2.getMessage(), ex2);
        }
    }

    protected final Unmarshaller createUnmarshaller(Class clazz2) throws JAXBException {
        try {
            JAXBContext jaxbContext = this.getJaxbContext(clazz2);
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex2) {
            throw new HttpMessageConversionException("Could not create Unmarshaller for class [" + clazz2 + "]: " + ex2.getMessage(), ex2);
        }
    }

    protected final JAXBContext getJaxbContext(Class clazz2) {
        Assert.notNull(clazz2, "'clazz' must not be null");
        JAXBContext jaxbContext = (JAXBContext)this.jaxbContexts.get(clazz2);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz2});
                this.jaxbContexts.putIfAbsent(clazz2, jaxbContext);
            }
            catch (JAXBException ex2) {
                throw new HttpMessageConversionException("Could not instantiate JAXBContext for class [" + clazz2 + "]: " + ex2.getMessage(), ex2);
            }
        }
        return jaxbContext;
    }
}

