/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.IOException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractJaxb2HttpMessageConverter;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaxb2RootElementHttpMessageConverter
extends AbstractJaxb2HttpMessageConverter<Object> {
    @Override
    public boolean canRead(Class<?> clazz2, MediaType mediaType) {
        return (clazz2.isAnnotationPresent(XmlRootElement.class) || clazz2.isAnnotationPresent(XmlType.class)) && this.canRead(mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz2, MediaType mediaType) {
        return AnnotationUtils.findAnnotation(clazz2, XmlRootElement.class) != null && this.canWrite(mediaType);
    }

    @Override
    protected boolean supports(Class<?> clazz2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object readFromSource(Class<?> clazz2, HttpHeaders headers2, Source source) throws IOException {
        try {
            Unmarshaller unmarshaller = this.createUnmarshaller(clazz2);
            if (clazz2.isAnnotationPresent(XmlRootElement.class)) {
                return unmarshaller.unmarshal(source);
            }
            JAXBElement jaxbElement = unmarshaller.unmarshal(source, clazz2);
            return jaxbElement.getValue();
        }
        catch (UnmarshalException ex2) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz2 + "]: " + ex2.getMessage(), ex2);
        }
        catch (JAXBException ex3) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex3.getMessage(), ex3);
        }
    }

    @Override
    protected void writeToResult(Object o, HttpHeaders headers2, Result result2) throws IOException {
        try {
            Class<?> clazz2 = ClassUtils.getUserClass(o);
            Marshaller marshaller = this.createMarshaller(clazz2);
            this.setCharset(headers2.getContentType(), marshaller);
            marshaller.marshal(o, result2);
        }
        catch (MarshalException ex2) {
            throw new HttpMessageNotWritableException("Could not marshal [" + o + "]: " + ex2.getMessage(), ex2);
        }
        catch (JAXBException ex3) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex3.getMessage(), ex3);
        }
    }

    private void setCharset(MediaType contentType, Marshaller marshaller) throws PropertyException {
        if (contentType != null && contentType.getCharSet() != null) {
            marshaller.setProperty("jaxb.encoding", (Object)contentType.getCharSet().name());
        }
    }
}

