/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingHttpMessageConverter
extends AbstractXmlHttpMessageConverter<Object> {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallingHttpMessageConverter() {
    }

    public MarshallingHttpMessageConverter(Marshaller marshaller) {
        Assert.notNull(marshaller, "Marshaller must not be null");
        this.marshaller = marshaller;
        if (marshaller instanceof Unmarshaller) {
            this.unmarshaller = (Unmarshaller)marshaller;
        }
    }

    public MarshallingHttpMessageConverter(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull(marshaller, "Marshaller must not be null");
        Assert.notNull(unmarshaller, "Unmarshaller must not be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public boolean supports(Class<?> clazz2) {
        return this.unmarshaller.supports(clazz2);
    }

    @Override
    protected Object readFromSource(Class<?> clazz2, HttpHeaders headers2, Source source) throws IOException {
        Assert.notNull(this.unmarshaller, "Property 'unmarshaller' is required");
        try {
            Object result2 = this.unmarshaller.unmarshal(source);
            if (!clazz2.isInstance(result2)) {
                throw new TypeMismatchException(result2, clazz2);
            }
            return result2;
        }
        catch (UnmarshallingFailureException ex2) {
            throw new HttpMessageNotReadableException("Could not read [" + clazz2 + "]", ex2);
        }
    }

    @Override
    protected void writeToResult(Object o, HttpHeaders headers2, Result result2) throws IOException {
        Assert.notNull(this.marshaller, "Property 'marshaller' is required");
        try {
            this.marshaller.marshal(o, result2);
        }
        catch (MarshallingFailureException ex2) {
            throw new HttpMessageNotWritableException("Could not write [" + o + "]", ex2);
        }
    }
}

