/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceHttpMessageConverter<T extends Source>
extends AbstractXmlHttpMessageConverter<T> {
    @Override
    public boolean supports(Class<?> clazz2) {
        return DOMSource.class.equals(clazz2) || SAXSource.class.equals(clazz2) || StreamSource.class.equals(clazz2) || Source.class.equals(clazz2);
    }

    @Override
    protected T readFromSource(Class clazz2, HttpHeaders headers2, Source source) throws IOException {
        try {
            if (DOMSource.class.equals((Object)clazz2)) {
                DOMResult domResult = new DOMResult();
                this.transform(source, domResult);
                return (T)new DOMSource(domResult.getNode());
            }
            if (SAXSource.class.equals((Object)clazz2)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new SAXSource(new InputSource(bis));
            }
            if (StreamSource.class.equals((Object)clazz2) || Source.class.equals((Object)clazz2)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new StreamSource(bis);
            }
            throw new HttpMessageConversionException("Could not read class [" + clazz2 + "]. Only DOMSource, SAXSource, and StreamSource are supported.");
        }
        catch (TransformerException ex2) {
            throw new HttpMessageNotReadableException("Could not transform from [" + source + "] to [" + clazz2 + "]", ex2);
        }
    }

    private ByteArrayInputStream transformToByteArrayInputStream(Source source) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transform(source, new StreamResult(bos));
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @Override
    protected Long getContentLength(T t2, MediaType contentType) {
        if (t2 instanceof DOMSource) {
            try {
                CountingOutputStream os2 = new CountingOutputStream();
                this.transform((Source)t2, new StreamResult(os2));
                return os2.count;
            }
            catch (TransformerException transformerException) {}
        }
        return null;
    }

    @Override
    protected void writeToResult(T t2, HttpHeaders headers2, Result result2) throws IOException {
        try {
            this.transform((Source)t2, result2);
        }
        catch (TransformerException ex2) {
            throw new HttpMessageNotWritableException("Could not transform [" + t2 + "] to [" + result2 + "]", ex2);
        }
    }

    private static class CountingOutputStream
    extends OutputStream {
        private long count = 0L;

        private CountingOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.count;
        }

        public void write(byte[] b) throws IOException {
            this.count += (long)b.length;
        }

        public void write(byte[] b, int off, int len2) throws IOException {
            this.count += (long)len2;
        }
    }
}

