/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.springframework.instrument.classloading.jboss.JBossMCTranslatorAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class JBossMCAdapter
implements JBossClassLoaderAdapter {
    private static final String TRANSLATOR_NAME = "org.jboss.util.loading.Translator";
    private static final String POLICY_NAME = "org.jboss.classloader.spi.base.BaseClassLoaderPolicy";
    private static final String DOMAIN_NAME = "org.jboss.classloader.spi.base.BaseClassLoaderDomain";
    private static final String DEDICATED_SYSTEM = "org.jboss.classloader.spi.ClassLoaderSystem";
    private static final String LOADER_NAME = "org.jboss.classloader.spi.base.BaseClassLoader";
    private static final String GET_POLICY = "getPolicy";
    private static final String GET_DOMAIN = "getClassLoaderDomain";
    private static final String GET_SYSTEM = "getClassLoaderSystem";
    private static final String ADD_TRANSLATOR_NAME = "addTranslator";
    private static final String SET_TRANSLATOR_NAME = "setTranslator";
    private final ClassLoader classLoader;
    private final Class<?> translatorClass;
    private final Method addTranslator;
    private final Object target;

    JBossMCAdapter(ClassLoader classLoader) {
        Class<?> clazzLoaderType = null;
        try {
            clazzLoaderType = classLoader.loadClass(LOADER_NAME);
            Object clazzLoader = null;
            ClassLoader cl = classLoader;
            while (cl != null && clazzLoader == null) {
                if (clazzLoaderType.isInstance(cl)) {
                    clazzLoader = cl;
                }
                cl = cl.getParent();
            }
            if (clazzLoader == null) {
                throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: " + "A [" + LOADER_NAME + "] implementation is required.");
            }
            this.classLoader = clazzLoader;
            classLoader = clazzLoader.getClass().getClassLoader();
            Method method = clazzLoaderType.getDeclaredMethod(GET_POLICY, new Class[0]);
            ReflectionUtils.makeAccessible(method);
            Object policy = method.invoke((Object)this.classLoader, new Object[0]);
            Object addTarget = null;
            Method addMethod = null;
            this.translatorClass = classLoader.loadClass(TRANSLATOR_NAME);
            Class<?> clazz2 = classLoader.loadClass(POLICY_NAME);
            try {
                addMethod = clazz2.getDeclaredMethod(ADD_TRANSLATOR_NAME, this.translatorClass);
                addTarget = policy;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (addMethod == null) {
                method = clazz2.getDeclaredMethod(GET_DOMAIN, new Class[0]);
                ReflectionUtils.makeAccessible(method);
                Object domain = method.invoke(policy, new Object[0]);
                clazz2 = classLoader.loadClass(DOMAIN_NAME);
                method = clazz2.getDeclaredMethod(GET_SYSTEM, new Class[0]);
                ReflectionUtils.makeAccessible(method);
                Object system = method.invoke(domain, new Object[0]);
                clazz2 = classLoader.loadClass(DEDICATED_SYSTEM);
                Assert.isInstanceOf(clazz2, system, "JBoss LoadTimeWeaver requires JBoss loader system of type " + clazz2.getName() + " on JBoss 5.0.x");
                addMethod = clazz2.getDeclaredMethod(SET_TRANSLATOR_NAME, this.translatorClass);
                addTarget = system;
            }
            this.addTranslator = addMethod;
            this.target = addTarget;
        }
        catch (Exception ex2) {
            throw new IllegalStateException("Could not initialize JBoss LoadTimeWeaver because the JBoss 5 API classes are not available", ex2);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        JBossMCTranslatorAdapter adapter = new JBossMCTranslatorAdapter(transformer);
        Object adapterInstance = Proxy.newProxyInstance(this.translatorClass.getClassLoader(), new Class[]{this.translatorClass}, (InvocationHandler)adapter);
        try {
            this.addTranslator.invoke(this.target, adapterInstance);
        }
        catch (Exception ex2) {
            throw new IllegalStateException("Could not add transformer on JBoss 5/6 classloader " + this.classLoader, ex2);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }
}

