/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JBossMCTranslatorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;

    public JBossMCTranslatorAdapter(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        String name = method.getName();
        if ("equals".equals(name)) {
            return proxy == args2[0];
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        if ("toString".equals(name)) {
            return this.toString();
        }
        if ("transform".equals(name)) {
            return this.transform((ClassLoader)args2[0], (String)args2[1], (Class)args2[2], (ProtectionDomain)args2[3], (byte[])args2[4]);
        }
        if ("unregisterClassLoader".equals(name)) {
            this.unregisterClassLoader((ClassLoader)args2[0]);
            return null;
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws Exception {
        return this.transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public void unregisterClassLoader(ClassLoader loader) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

