/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.oc4j;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

class OC4JClassPreprocessorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;

    public OC4JClassPreprocessorAdapter(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        String name = method.getName();
        if ("equals".equals(name)) {
            return proxy == args2[0];
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        if ("toString".equals(name)) {
            return this.toString();
        }
        if ("initialize".equals(name)) {
            this.initialize(proxy, (ClassLoader)args2[0]);
            return null;
        }
        if ("processClass".equals(name)) {
            return this.processClass((String)args2[0], (byte[])args2[1], (Integer)args2[2], (Integer)args2[3], (ProtectionDomain)args2[4], (ClassLoader)args2[5]);
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public Object initialize(Object proxy, ClassLoader loader) {
        return proxy;
    }

    public byte[] processClass(String className, byte[] origClassBytes, int offset2, int length2, ProtectionDomain pd, ClassLoader loader) {
        try {
            byte[] tempArray = new byte[length2];
            System.arraycopy(origClassBytes, offset2, tempArray, 0, length2);
            byte[] result2 = this.transformer.transform(loader, className.replace('.', '/'), null, pd, tempArray);
            return result2 != null ? result2 : origClassBytes;
        }
        catch (IllegalClassFormatException ex2) {
            throw new IllegalStateException("Cannot transform because of illegal class format", ex2);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        builder.append(" for transformer: ");
        builder.append(this.transformer);
        return builder.toString();
    }
}

