/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.naming.Context;
import javax.naming.NamingException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.jndi.JndiObjectTargetSource;
import org.springframework.jndi.JndiTemplate;
import org.springframework.jndi.TypeMismatchNamingException;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiObjectFactoryBean
extends JndiObjectLocator
implements FactoryBean<Object>,
BeanClassLoaderAware {
    private Class[] proxyInterfaces;
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private boolean exposeAccessContext = false;
    private Object defaultObject;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object jndiObject;

    public void setProxyInterface(Class proxyInterface) {
        this.proxyInterfaces = new Class[]{proxyInterface};
    }

    public void setProxyInterfaces(Class[] proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setExposeAccessContext(boolean exposeAccessContext) {
        this.exposeAccessContext = exposeAccessContext;
    }

    public void setDefaultObject(Object defaultObject) {
        this.defaultObject = defaultObject;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        super.afterPropertiesSet();
        if (this.proxyInterfaces != null || !this.lookupOnStartup || !this.cache || this.exposeAccessContext) {
            if (this.defaultObject != null) {
                throw new IllegalArgumentException("'defaultObject' is not supported in combination with 'proxyInterface'");
            }
            this.jndiObject = JndiObjectProxyFactory.createJndiObjectProxy(this);
        } else {
            if (this.defaultObject != null && this.getExpectedType() != null && !this.getExpectedType().isInstance(this.defaultObject)) {
                throw new IllegalArgumentException("Default object [" + this.defaultObject + "] of type [" + this.defaultObject.getClass().getName() + "] is not of expected type [" + this.getExpectedType().getName() + "]");
            }
            this.jndiObject = this.lookupWithFallback();
        }
    }

    protected Object lookupWithFallback() throws NamingException {
        ClassLoader originalClassLoader = ClassUtils.overrideThreadContextClassLoader(this.beanClassLoader);
        try {
            Object object = this.lookup();
            return object;
        }
        catch (TypeMismatchNamingException ex2) {
            throw ex2;
        }
        catch (NamingException ex3) {
            if (this.defaultObject != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("JNDI lookup failed - returning specified default object instead", ex3);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("JNDI lookup failed - returning specified default object instead: " + ex3);
                }
                Object object = this.defaultObject;
                return object;
            }
            throw ex3;
        }
        finally {
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    @Override
    public Object getObject() {
        return this.jndiObject;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.proxyInterfaces != null) {
            if (this.proxyInterfaces.length == 1) {
                return this.proxyInterfaces[0];
            }
            if (this.proxyInterfaces.length > 1) {
                return this.createCompositeInterface(this.proxyInterfaces);
            }
        }
        if (this.jndiObject != null) {
            return this.jndiObject.getClass();
        }
        return this.getExpectedType();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected Class createCompositeInterface(Class[] interfaces2) {
        return ClassUtils.createCompositeInterface(interfaces2, this.beanClassLoader);
    }

    private static class JndiContextExposingInterceptor
    implements MethodInterceptor {
        private final JndiTemplate jndiTemplate;

        public JndiContextExposingInterceptor(JndiTemplate jndiTemplate) {
            this.jndiTemplate = jndiTemplate;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Context ctx = this.isEligible(invocation.getMethod()) ? this.jndiTemplate.getContext() : null;
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                this.jndiTemplate.releaseContext(ctx);
            }
        }

        protected boolean isEligible(Method method) {
            return !Object.class.equals(method.getDeclaringClass());
        }
    }

    private static class JndiObjectProxyFactory {
        private JndiObjectProxyFactory() {
        }

        private static Object createJndiObjectProxy(JndiObjectFactoryBean jof) throws NamingException {
            JndiObjectTargetSource targetSource = new JndiObjectTargetSource();
            targetSource.setJndiTemplate(jof.getJndiTemplate());
            targetSource.setJndiName(jof.getJndiName());
            targetSource.setExpectedType(jof.getExpectedType());
            targetSource.setResourceRef(jof.isResourceRef());
            targetSource.setLookupOnStartup(jof.lookupOnStartup);
            targetSource.setCache(jof.cache);
            targetSource.afterPropertiesSet();
            ProxyFactory proxyFactory = new ProxyFactory();
            if (jof.proxyInterfaces != null) {
                proxyFactory.setInterfaces(jof.proxyInterfaces);
            } else {
                Class<?>[] ifcs;
                Class<?> targetClass = targetSource.getTargetClass();
                if (targetClass == null) {
                    throw new IllegalStateException("Cannot deactivate 'lookupOnStartup' without specifying a 'proxyInterface' or 'expectedType'");
                }
                Class<?>[] classArray = ifcs = ClassUtils.getAllInterfacesForClass(targetClass, jof.beanClassLoader);
                int n = ifcs.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    if (Modifier.isPublic(ifc.getModifiers())) {
                        proxyFactory.addInterface(ifc);
                    }
                    ++n2;
                }
            }
            if (jof.exposeAccessContext) {
                proxyFactory.addAdvice(new JndiContextExposingInterceptor(jof.getJndiTemplate()));
            }
            proxyFactory.setTargetSource(targetSource);
            return proxyFactory.getProxy(jof.beanClassLoader);
        }
    }
}

