/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.jndi.TypeMismatchNamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJndiBeanFactory
extends JndiLocatorSupport
implements BeanFactory {
    private final Set<String> shareableResources = new HashSet<String>();
    private final Map<String, Object> singletonObjects = new HashMap<String, Object>();
    private final Map<String, Class> resourceTypes = new HashMap<String, Class>();

    public SimpleJndiBeanFactory() {
        this.setResourceRef(true);
    }

    public void setShareableResources(String[] shareableResources) {
        this.shareableResources.addAll((Collection<String>)Arrays.asList(shareableResources));
    }

    public void addShareableResource(String shareableResource) {
        this.shareableResources.add(shareableResource);
    }

    @Override
    public Object getBean(String name) throws BeansException {
        return this.getBean(name, Object.class);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        try {
            if (this.isSingleton(name)) {
                return this.doGetSingleton(name, requiredType);
            }
            return this.lookup(name, requiredType);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new NoSuchBeanDefinitionException(name, "not found in JNDI environment");
        }
        catch (TypeMismatchNamingException ex2) {
            throw new BeanNotOfRequiredTypeException(name, ex2.getRequiredType(), ex2.getActualType());
        }
        catch (NamingException ex3) {
            throw new BeanDefinitionStoreException("JNDI environment", name, "JNDI lookup failed", ex3);
        }
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType.getSimpleName(), requiredType);
    }

    @Override
    public Object getBean(String name, Object ... args2) throws BeansException {
        if (args2 != null) {
            throw new UnsupportedOperationException("SimpleJndiBeanFactory does not support explicit bean creation arguments)");
        }
        return this.getBean(name);
    }

    @Override
    public boolean containsBean(String name) {
        if (this.singletonObjects.containsKey(name) || this.resourceTypes.containsKey(name)) {
            return true;
        }
        try {
            this.doGetType(name);
            return true;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    @Override
    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.shareableResources.contains(name);
    }

    @Override
    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return !this.shareableResources.contains(name);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        Class<?> type = this.getType(name);
        return targetType == null || type != null && targetType.isAssignableFrom(type);
    }

    @Override
    public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        try {
            return this.doGetType(name);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new NoSuchBeanDefinitionException(name, "not found in JNDI environment");
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    @Override
    public String[] getAliases(String name) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetSingleton(String name, Class<T> requiredType) throws NamingException {
        Map<String, Object> map3 = this.singletonObjects;
        synchronized (map3) {
            if (this.singletonObjects.containsKey(name)) {
                Object jndiObject = this.singletonObjects.get(name);
                if (requiredType != null && !requiredType.isInstance(jndiObject)) {
                    throw new TypeMismatchNamingException(this.convertJndiName(name), requiredType, jndiObject != null ? jndiObject.getClass() : null);
                }
                return (T)jndiObject;
            }
            T jndiObject = this.lookup(name, requiredType);
            this.singletonObjects.put(name, jndiObject);
            return jndiObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class doGetType(String name) throws NamingException {
        if (this.isSingleton(name)) {
            Object jndiObject = this.doGetSingleton(name, null);
            return jndiObject != null ? jndiObject.getClass() : null;
        }
        Map<String, Class> map3 = this.resourceTypes;
        synchronized (map3) {
            if (this.resourceTypes.containsKey(name)) {
                return this.resourceTypes.get(name);
            }
            Object jndiObject = this.lookup(name, null);
            Class<?> type = jndiObject != null ? jndiObject.getClass() : null;
            this.resourceTypes.put(name, type);
            return type;
        }
    }
}

