/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.server.BurlapSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;

public class BurlapExporter
extends RemoteExporter
implements InitializingBean {
    private BurlapSkeleton skeleton;

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        this.checkService();
        this.checkServiceInterface();
        this.skeleton = new BurlapSkeleton(this.getProxyForService(), this.getServiceInterface());
    }

    public void invoke(InputStream inputStream, OutputStream outputStream) throws Throwable {
        Assert.notNull(this.skeleton, "Burlap exporter has not been initialized");
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            this.skeleton.invoke(new BurlapInput(inputStream), new BurlapOutput(outputStream));
        }
        catch (Throwable throwable2) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            this.resetThreadContextClassLoader(originalClassLoader);
            throw throwable2;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        this.resetThreadContextClassLoader(originalClassLoader);
    }
}

