/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteInvocationFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationFactory;
import org.springframework.util.ReflectionUtils;

public class JndiRmiClientInterceptor
extends JndiObjectLocator
implements MethodInterceptor,
InitializingBean {
    private Class serviceInterface;
    private RemoteInvocationFactory remoteInvocationFactory = new DefaultRemoteInvocationFactory();
    private boolean lookupStubOnStartup = true;
    private boolean cacheStub = true;
    private boolean refreshStubOnConnectFailure = false;
    private Object cachedStub;
    private final Object stubMonitor = new Object();

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setRemoteInvocationFactory(RemoteInvocationFactory remoteInvocationFactory) {
        this.remoteInvocationFactory = remoteInvocationFactory;
    }

    public RemoteInvocationFactory getRemoteInvocationFactory() {
        return this.remoteInvocationFactory;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setCacheStub(boolean cacheStub) {
        this.cacheStub = cacheStub;
    }

    public void setRefreshStubOnConnectFailure(boolean refreshStubOnConnectFailure) {
        this.refreshStubOnConnectFailure = refreshStubOnConnectFailure;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws RemoteLookupFailureException {
        if (this.lookupStubOnStartup) {
            Object remoteObj = this.lookupStub();
            if (this.logger.isDebugEnabled()) {
                if (remoteObj instanceof RmiInvocationHandler) {
                    this.logger.debug("JNDI RMI object [" + this.getJndiName() + "] is an RMI invoker");
                } else if (this.getServiceInterface() != null) {
                    boolean isImpl = this.getServiceInterface().isInstance(remoteObj);
                    this.logger.debug("Using service interface [" + this.getServiceInterface().getName() + "] for JNDI RMI object [" + this.getJndiName() + "] - " + (!isImpl ? "not " : "") + "directly implemented");
                }
            }
            if (this.cacheStub) {
                this.cachedStub = remoteObj;
            }
        }
    }

    protected Object lookupStub() throws RemoteLookupFailureException {
        try {
            Object stub = this.lookup();
            if (this.getServiceInterface() != null && !(stub instanceof RmiInvocationHandler)) {
                try {
                    stub = PortableRemoteObject.narrow((Object)stub, (Class)this.getServiceInterface());
                }
                catch (ClassCastException ex2) {
                    throw new RemoteLookupFailureException("Could not narrow RMI stub to service interface [" + this.getServiceInterface().getName() + "]", ex2);
                }
            }
            return stub;
        }
        catch (NamingException ex3) {
            throw new RemoteLookupFailureException("JNDI lookup for RMI service [" + this.getJndiName() + "] failed", ex3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStub() throws NamingException, RemoteLookupFailureException {
        if (!this.cacheStub || this.lookupStubOnStartup && !this.refreshStubOnConnectFailure) {
            return this.cachedStub != null ? this.cachedStub : this.lookupStub();
        }
        Object object = this.stubMonitor;
        synchronized (object) {
            if (this.cachedStub == null) {
                this.cachedStub = this.lookupStub();
            }
            return this.cachedStub;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object stub = null;
        try {
            stub = this.getStub();
        }
        catch (NamingException ex2) {
            throw new RemoteLookupFailureException("JNDI lookup for RMI service [" + this.getJndiName() + "] failed", ex2);
        }
        try {
            return this.doInvoke(invocation, stub);
        }
        catch (RemoteConnectFailureException ex3) {
            return this.handleRemoteConnectFailure(invocation, ex3);
        }
        catch (RemoteException ex4) {
            if (this.isConnectFailure(ex4)) {
                return this.handleRemoteConnectFailure(invocation, ex4);
            }
            throw ex4;
        }
        catch (SystemException ex5) {
            if (this.isConnectFailure(ex5)) {
                return this.handleRemoteConnectFailure(invocation, (Exception)((Object)ex5));
            }
            throw ex5;
        }
    }

    protected boolean isConnectFailure(RemoteException ex2) {
        return RmiClientInterceptorUtils.isConnectFailure(ex2);
    }

    protected boolean isConnectFailure(SystemException ex2) {
        return ex2 instanceof OBJECT_NOT_EXIST;
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex2) throws Throwable {
        if (this.refreshStubOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not connect to RMI service [" + this.getJndiName() + "] - retrying", ex2);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not connect to RMI service [" + this.getJndiName() + "] - retrying");
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        Object freshStub = null;
        Object object = this.stubMonitor;
        synchronized (object) {
            this.cachedStub = null;
            freshStub = this.lookupStub();
            if (this.cacheStub) {
                this.cachedStub = freshStub;
            }
        }
        return this.doInvoke(invocation, freshStub);
    }

    protected Object doInvoke(MethodInvocation invocation, Object stub) throws Throwable {
        if (stub instanceof RmiInvocationHandler) {
            try {
                return this.doInvoke(invocation, (RmiInvocationHandler)stub);
            }
            catch (RemoteException ex2) {
                throw this.convertRmiAccessException(ex2, invocation.getMethod());
            }
            catch (SystemException ex3) {
                throw this.convertCorbaAccessException(ex3, invocation.getMethod());
            }
            catch (InvocationTargetException ex4) {
                throw ex4.getTargetException();
            }
            catch (Throwable ex5) {
                throw new RemoteInvocationFailureException("Invocation of method [" + invocation.getMethod() + "] failed in RMI service [" + this.getJndiName() + "]", ex5);
            }
        }
        try {
            return RmiClientInterceptorUtils.invokeRemoteMethod(invocation, stub);
        }
        catch (InvocationTargetException ex6) {
            Throwable targetEx = ex6.getTargetException();
            if (targetEx instanceof RemoteException) {
                throw this.convertRmiAccessException((RemoteException)targetEx, invocation.getMethod());
            }
            if (targetEx instanceof SystemException) {
                throw this.convertCorbaAccessException((SystemException)targetEx, invocation.getMethod());
            }
            throw targetEx;
        }
    }

    protected Object doInvoke(MethodInvocation methodInvocation, RmiInvocationHandler invocationHandler) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (AopUtils.isToStringMethod(methodInvocation.getMethod())) {
            return "RMI invoker proxy for service URL [" + this.getJndiName() + "]";
        }
        return invocationHandler.invoke(this.createRemoteInvocation(methodInvocation));
    }

    protected RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
        return this.getRemoteInvocationFactory().createRemoteInvocation(methodInvocation);
    }

    private Exception convertRmiAccessException(RemoteException ex2, Method method) {
        return RmiClientInterceptorUtils.convertRmiAccessException(method, ex2, this.isConnectFailure(ex2), this.getJndiName());
    }

    private Exception convertCorbaAccessException(SystemException ex2, Method method) {
        if (ReflectionUtils.declaresException(method, RemoteException.class)) {
            return new RemoteException("Failed to access CORBA service [" + this.getJndiName() + "]", ex2);
        }
        if (this.isConnectFailure(ex2)) {
            return new RemoteConnectFailureException("Could not connect to CORBA service [" + this.getJndiName() + "]", ex2);
        }
        return new RemoteAccessException("Could not access CORBA service [" + this.getJndiName() + "]", ex2);
    }
}

