/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.util.ReflectionUtils;

public abstract class RmiClientInterceptorUtils {
    private static final String ORACLE_CONNECTION_EXCEPTION = "com.evermind.server.rmi.RMIConnectionException";
    private static final Log logger = LogFactory.getLog(RmiClientInterceptorUtils.class);

    @Deprecated
    public static Object invoke(MethodInvocation invocation, Remote stub, String serviceName) throws Throwable {
        try {
            return RmiClientInterceptorUtils.invokeRemoteMethod(invocation, stub);
        }
        catch (InvocationTargetException ex2) {
            Throwable targetEx = ex2.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, serviceName);
            }
            throw targetEx;
        }
    }

    @Deprecated
    public static Object doInvoke(MethodInvocation invocation, Remote stub) throws InvocationTargetException {
        return RmiClientInterceptorUtils.invokeRemoteMethod(invocation, stub);
    }

    public static Object invokeRemoteMethod(MethodInvocation invocation, Object stub) throws InvocationTargetException {
        Method method = invocation.getMethod();
        try {
            if (method.getDeclaringClass().isInstance(stub)) {
                return method.invoke(stub, invocation.getArguments());
            }
            Method stubMethod = stub.getClass().getMethod(method.getName(), method.getParameterTypes());
            return stubMethod.invoke(stub, invocation.getArguments());
        }
        catch (InvocationTargetException ex2) {
            throw ex2;
        }
        catch (NoSuchMethodException ex3) {
            throw new RemoteProxyFailureException("No matching RMI stub method found for: " + method, ex3);
        }
        catch (Throwable ex4) {
            throw new RemoteProxyFailureException("Invocation of RMI stub method failed: " + method, ex4);
        }
    }

    public static Exception convertRmiAccessException(Method method, Throwable ex2, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, ex2);
        }
        if (ReflectionUtils.declaresException(method, RemoteException.class)) {
            return new RemoteException(message, ex2);
        }
        return new RemoteAccessException(message, ex2);
    }

    public static Exception convertRmiAccessException(Method method, RemoteException ex2, String serviceName) {
        return RmiClientInterceptorUtils.convertRmiAccessException(method, ex2, RmiClientInterceptorUtils.isConnectFailure(ex2), serviceName);
    }

    public static Exception convertRmiAccessException(Method method, RemoteException ex2, boolean isConnectFailure, String serviceName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Remote service [" + serviceName + "] threw exception", ex2);
        }
        if (ReflectionUtils.declaresException(method, ex2.getClass())) {
            return ex2;
        }
        if (isConnectFailure) {
            return new RemoteConnectFailureException("Could not connect to remote service [" + serviceName + "]", ex2);
        }
        return new RemoteAccessException("Could not access remote service [" + serviceName + "]", ex2);
    }

    public static boolean isConnectFailure(RemoteException ex2) {
        return ex2 instanceof ConnectException || ex2 instanceof ConnectIOException || ex2 instanceof UnknownHostException || ex2 instanceof NoSuchObjectException || ex2 instanceof StubNotFoundException || ex2.getCause() instanceof SocketException || RmiClientInterceptorUtils.isCorbaConnectFailure(ex2.getCause()) || ORACLE_CONNECTION_EXCEPTION.equals(ex2.getClass().getName());
    }

    private static boolean isCorbaConnectFailure(Throwable ex2) {
        return (ex2 instanceof COMM_FAILURE || ex2 instanceof NO_RESPONSE) && ((SystemException)ex2).completed == CompletionStatus.COMPLETED_NO;
    }
}

