/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import java.lang.reflect.InvocationTargetException;
import org.springframework.remoting.support.DefaultRemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteInvocationResult;

public abstract class RemoteInvocationBasedExporter
extends RemoteExporter {
    private RemoteInvocationExecutor remoteInvocationExecutor = new DefaultRemoteInvocationExecutor();

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    public RemoteInvocationExecutor getRemoteInvocationExecutor() {
        return this.remoteInvocationExecutor;
    }

    protected Object invoke(RemoteInvocation invocation, Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Executing " + invocation);
        }
        try {
            return this.getRemoteInvocationExecutor().invoke(invocation, targetObject);
        }
        catch (NoSuchMethodException ex2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Could not find target method for " + invocation, ex2);
            }
            throw ex2;
        }
        catch (IllegalAccessException ex3) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Could not access target method for " + invocation, ex3);
            }
            throw ex3;
        }
        catch (InvocationTargetException ex4) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Target method failed for " + invocation, ex4.getTargetException());
            }
            throw ex4;
        }
    }

    protected RemoteInvocationResult invokeAndCreateResult(RemoteInvocation invocation, Object targetObject) {
        try {
            Object value2 = this.invoke(invocation, targetObject);
            return new RemoteInvocationResult(value2);
        }
        catch (Throwable ex2) {
            return new RemoteInvocationResult(ex2);
        }
    }
}

