/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.backportconcurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.SchedulingTaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTaskExecutor
implements SchedulingTaskExecutor,
Executor {
    private Executor concurrentExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public final void setConcurrentExecutor(Executor concurrentExecutor) {
        this.concurrentExecutor = concurrentExecutor != null ? concurrentExecutor : Executors.newSingleThreadExecutor();
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    @Override
    public void execute(Runnable task) {
        try {
            this.concurrentExecutor.execute(task);
        }
        catch (RejectedExecutionException ex2) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex2);
        }
    }

    @Override
    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }
}

