/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element2) {
        return "org.springframework.scheduling.config.TaskExecutorFactoryBean";
    }

    protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String queueCapacity;
        String keepAliveSeconds = element2.getAttribute("keep-alive");
        if (StringUtils.hasText(keepAliveSeconds)) {
            builder.addPropertyValue("keepAliveSeconds", keepAliveSeconds);
        }
        if (StringUtils.hasText(queueCapacity = element2.getAttribute("queue-capacity"))) {
            builder.addPropertyValue("queueCapacity", queueCapacity);
        }
        this.configureRejectionPolicy(element2, builder);
        String poolSize = element2.getAttribute("pool-size");
        if (StringUtils.hasText(poolSize)) {
            builder.addPropertyValue("poolSize", poolSize);
        }
    }

    private void configureRejectionPolicy(Element element2, BeanDefinitionBuilder builder) {
        String rejectionPolicy = element2.getAttribute("rejection-policy");
        if (!StringUtils.hasText(rejectionPolicy)) {
            return;
        }
        String prefix2 = "java.util.concurrent.ThreadPoolExecutor.";
        if (builder.getRawBeanDefinition().getBeanClassName().contains("backport")) {
            prefix2 = "edu.emory.mathcs.backport." + prefix2;
        }
        String policyClassName = rejectionPolicy.equals("ABORT") ? String.valueOf(prefix2) + "AbortPolicy" : (rejectionPolicy.equals("CALLER_RUNS") ? String.valueOf(prefix2) + "CallerRunsPolicy" : (rejectionPolicy.equals("DISCARD") ? String.valueOf(prefix2) + "DiscardPolicy" : (rejectionPolicy.equals("DISCARD_OLDEST") ? String.valueOf(prefix2) + "DiscardOldestPolicy" : rejectionPolicy)));
        builder.addPropertyValue("rejectedExecutionHandler", new RootBeanDefinition(policyClassName));
    }
}

