/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledTasksBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ELEMENT_SCHEDULED = "scheduled";

    protected boolean shouldGenerateId() {
        return true;
    }

    protected String getBeanClassName(Element element2) {
        return "org.springframework.scheduling.config.ScheduledTaskRegistrar";
    }

    protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setLazyInit(false);
        ManagedMap<RuntimeBeanReference, String> cronTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        ManagedMap<RuntimeBeanReference, String> fixedDelayTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        ManagedMap<RuntimeBeanReference, String> fixedRateTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        ManagedMap<RuntimeBeanReference, RuntimeBeanReference> triggerTaskMap = new ManagedMap<RuntimeBeanReference, RuntimeBeanReference>();
        NodeList childNodes = element2.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (this.isScheduledElement(child, parserContext)) {
                Element taskElement = (Element)child;
                String ref = taskElement.getAttribute("ref");
                String method = taskElement.getAttribute("method");
                if (!StringUtils.hasText(ref) || !StringUtils.hasText(method)) {
                    parserContext.getReaderContext().error("Both 'ref' and 'method' are required", taskElement);
                } else {
                    boolean hasTriggerAttribute;
                    boolean hasFixedRateAttribute;
                    boolean hasFixedDelayAttribute;
                    RuntimeBeanReference runnableBeanRef = new RuntimeBeanReference(this.createRunnableBean(ref, method, taskElement, parserContext));
                    String cronAttribute = taskElement.getAttribute("cron");
                    String fixedDelayAttribute = taskElement.getAttribute("fixed-delay");
                    String fixedRateAttribute = taskElement.getAttribute("fixed-rate");
                    String triggerAttribute = taskElement.getAttribute("trigger");
                    boolean hasCronAttribute = StringUtils.hasText(cronAttribute);
                    if (!(hasCronAttribute | (hasFixedDelayAttribute = StringUtils.hasText(fixedDelayAttribute)) | (hasFixedRateAttribute = StringUtils.hasText(fixedRateAttribute)) | (hasTriggerAttribute = StringUtils.hasText(triggerAttribute)))) {
                        parserContext.getReaderContext().error("exactly one of the 'cron', 'fixed-delay', 'fixed-rate', or 'trigger' attributes is required", taskElement);
                    } else {
                        if (hasCronAttribute) {
                            cronTaskMap.put(runnableBeanRef, cronAttribute);
                        }
                        if (hasFixedDelayAttribute) {
                            fixedDelayTaskMap.put(runnableBeanRef, fixedDelayAttribute);
                        }
                        if (hasFixedRateAttribute) {
                            fixedRateTaskMap.put(runnableBeanRef, fixedRateAttribute);
                        }
                        if (hasTriggerAttribute) {
                            triggerTaskMap.put(runnableBeanRef, new RuntimeBeanReference(triggerAttribute));
                        }
                    }
                }
            }
            ++i;
        }
        String schedulerRef = element2.getAttribute("scheduler");
        if (StringUtils.hasText(schedulerRef)) {
            builder.addPropertyReference("taskScheduler", schedulerRef);
        }
        builder.addPropertyValue("cronTasks", cronTaskMap);
        builder.addPropertyValue("fixedDelayTasks", fixedDelayTaskMap);
        builder.addPropertyValue("fixedRateTasks", fixedRateTaskMap);
        builder.addPropertyValue("triggerTasks", triggerTaskMap);
    }

    private boolean isScheduledElement(Node node4, ParserContext parserContext) {
        return node4.getNodeType() == 1 && ELEMENT_SCHEDULED.equals(parserContext.getDelegate().getLocalName(node4));
    }

    private String createRunnableBean(String ref, String method, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition("org.springframework.scheduling.support.ScheduledMethodRunnable");
        builder.addConstructorArgReference(ref);
        builder.addConstructorArgValue(method);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource(taskElement));
        String generatedName = parserContext.getReaderContext().generateBeanName(builder.getRawBeanDefinition());
        parserContext.registerBeanComponent(new BeanComponentDefinition(builder.getBeanDefinition(), generatedName));
        return generatedName;
    }
}

