/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.springframework.util.ReflectionUtils;

public class ScheduledMethodRunnable
implements Runnable {
    private final Object target;
    private final Method method;

    public ScheduledMethodRunnable(Object target2, Method method) {
        this.target = target2;
        this.method = method;
    }

    public ScheduledMethodRunnable(Object target2, String methodName) throws NoSuchMethodException {
        this.target = target2;
        this.method = target2.getClass().getMethod(methodName, new Class[0]);
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void run() {
        try {
            ReflectionUtils.makeAccessible(this.method);
            this.method.invoke(this.target, new Object[0]);
        }
        catch (InvocationTargetException ex2) {
            ReflectionUtils.rethrowRuntimeException(ex2.getTargetException());
        }
        catch (IllegalAccessException ex3) {
            throw new UndeclaredThrowableException(ex3);
        }
    }
}

