/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.bsh;

import bsh.EvalError;
import java.io.IOException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.bsh.BshScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BshScriptFactory
implements ScriptFactory,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Class scriptClass;
    private final Object scriptClassMonitor = new Object();
    private boolean wasModifiedForTypeCheck = false;

    public BshScriptFactory(String scriptSourceLocator) {
        this(scriptSourceLocator, null);
    }

    public BshScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getScriptedObject(ScriptSource scriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            Class clazz2 = null;
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                boolean requiresScriptEvaluation = this.wasModifiedForTypeCheck && this.scriptClass == null;
                this.wasModifiedForTypeCheck = false;
                if (scriptSource.isModified() || requiresScriptEvaluation) {
                    Object result2 = BshScriptUtils.evaluateBshScript(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
                    if (result2 instanceof Class) {
                        this.scriptClass = (Class)result2;
                    } else {
                        return result2;
                    }
                }
                clazz2 = this.scriptClass;
            }
            if (clazz2 != null) {
                try {
                    return clazz2.newInstance();
                }
                catch (Throwable ex2) {
                    throw new ScriptCompilationException(scriptSource, "Could not instantiate script class: " + clazz2.getName(), ex2);
                }
            }
            return BshScriptUtils.createBshObject(scriptSource.getScriptAsString(), actualInterfaces, this.beanClassLoader);
        }
        catch (EvalError ex3) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        try {
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                if (scriptSource.isModified()) {
                    this.wasModifiedForTypeCheck = true;
                    this.scriptClass = BshScriptUtils.determineBshObjectType(scriptSource.getScriptAsString());
                }
                return this.scriptClass;
            }
        }
        catch (EvalError ex2) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            return scriptSource.isModified() || this.wasModifiedForTypeCheck;
        }
    }

    public String toString() {
        return "BshScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }
}

