/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.XThis;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BshScriptUtils {
    public static Object createBshObject(String scriptSource) throws EvalError {
        return BshScriptUtils.createBshObject(scriptSource, null, null);
    }

    public static Object createBshObject(String scriptSource, Class[] scriptInterfaces) throws EvalError {
        return BshScriptUtils.createBshObject(scriptSource, scriptInterfaces, ClassUtils.getDefaultClassLoader());
    }

    public static Object createBshObject(String scriptSource, Class[] scriptInterfaces, ClassLoader classLoader) throws EvalError {
        Object result2 = BshScriptUtils.evaluateBshScript(scriptSource, scriptInterfaces, classLoader);
        if (result2 instanceof Class) {
            Class clazz2 = (Class)result2;
            try {
                return clazz2.newInstance();
            }
            catch (Throwable ex2) {
                throw new IllegalStateException("Could not instantiate script class [" + clazz2.getName() + "]. Root cause is " + ex2);
            }
        }
        return result2;
    }

    static Class determineBshObjectType(String scriptSource) throws EvalError {
        Assert.hasText(scriptSource, "Script source must not be empty");
        Interpreter interpreter = new Interpreter();
        Object result2 = interpreter.eval(scriptSource);
        if (result2 instanceof Class) {
            return (Class)result2;
        }
        if (result2 != null) {
            return result2.getClass();
        }
        return null;
    }

    static Object evaluateBshScript(String scriptSource, Class[] scriptInterfaces, ClassLoader classLoader) throws EvalError {
        Assert.hasText(scriptSource, "Script source must not be empty");
        Interpreter interpreter = new Interpreter();
        Object result2 = interpreter.eval(scriptSource);
        if (result2 != null) {
            return result2;
        }
        Assert.notEmpty(scriptInterfaces, "Given script requires a script proxy: At least one script interface is required.");
        XThis xt = (XThis)interpreter.eval("return this");
        return Proxy.newProxyInstance(classLoader, scriptInterfaces, (InvocationHandler)new BshObjectInvocationHandler(xt));
    }

    public static class BshExecutionException
    extends NestedRuntimeException {
        private BshExecutionException(EvalError ex2) {
            super("BeanShell script execution failed", ex2);
        }
    }

    private static class BshObjectInvocationHandler
    implements InvocationHandler {
        private final XThis xt;

        public BshObjectInvocationHandler(XThis xt) {
            this.xt = xt;
        }

        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            Object result2;
            block7: {
                if (ReflectionUtils.isEqualsMethod(method)) {
                    return this.isProxyForSameBshObject(args2[0]);
                }
                if (ReflectionUtils.isHashCodeMethod(method)) {
                    return this.xt.hashCode();
                }
                if (ReflectionUtils.isToStringMethod(method)) {
                    return "BeanShell object [" + this.xt + "]";
                }
                try {
                    result2 = this.xt.invokeMethod(method.getName(), args2);
                    if (result2 != Primitive.NULL && result2 != Primitive.VOID) break block7;
                    return null;
                }
                catch (EvalError ex2) {
                    throw new BshExecutionException(ex2);
                }
            }
            if (result2 instanceof Primitive) {
                return ((Primitive)result2).getValue();
            }
            return result2;
        }

        private boolean isProxyForSameBshObject(Object other) {
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            return ih instanceof BshObjectInvocationHandler && this.xt.equals(((BshObjectInvocationHandler)ih).xt);
        }
    }
}

