/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.config;

import java.util.List;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.scripting.config.LangNamespaceUtils;
import org.springframework.scripting.support.ScriptFactoryPostProcessor;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ScriptBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String SCRIPT_SOURCE_ATTRIBUTE = "script-source";
    private static final String INLINE_SCRIPT_ELEMENT = "inline-script";
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String AUTOWIRE_ATTRIBUTE = "autowire";
    private static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    private static final String INIT_METHOD_ATTRIBUTE = "init-method";
    private static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";
    private static final String SCRIPT_INTERFACES_ATTRIBUTE = "script-interfaces";
    private static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";
    private static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";
    private static final String CUSTOMIZER_REF_ATTRIBUTE = "customizer-ref";
    private final String scriptFactoryClassName;

    public ScriptBeanDefinitionParser(String scriptFactoryClassName) {
        this.scriptFactoryClassName = scriptFactoryClassName;
    }

    protected AbstractBeanDefinition parseInternal(Element element2, ParserContext parserContext) {
        String proxyTargetClass;
        String value2 = this.resolveScriptSource(element2, parserContext.getReaderContext());
        if (value2 == null) {
            return null;
        }
        LangNamespaceUtils.registerScriptFactoryPostProcessorIfNecessary(parserContext.getRegistry());
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClassName(this.scriptFactoryClassName);
        bd.setSource(parserContext.extractSource(element2));
        bd.setAttribute(ScriptFactoryPostProcessor.LANGUAGE_ATTRIBUTE, element2.getLocalName());
        String scope = element2.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength(scope)) {
            bd.setScope(scope);
        }
        String autowire = element2.getAttribute(AUTOWIRE_ATTRIBUTE);
        int autowireMode = parserContext.getDelegate().getAutowireMode(autowire);
        if (autowireMode == 4) {
            autowireMode = 2;
        } else if (autowireMode == 3) {
            autowireMode = 0;
        }
        bd.setAutowireMode(autowireMode);
        String dependencyCheck = element2.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE);
        bd.setDependencyCheck(parserContext.getDelegate().getDependencyCheck(dependencyCheck));
        BeanDefinitionDefaults beanDefinitionDefaults = parserContext.getDelegate().getBeanDefinitionDefaults();
        String initMethod = element2.getAttribute(INIT_METHOD_ATTRIBUTE);
        if (StringUtils.hasLength(initMethod)) {
            bd.setInitMethodName(initMethod);
        } else if (beanDefinitionDefaults.getInitMethodName() != null) {
            bd.setInitMethodName(beanDefinitionDefaults.getInitMethodName());
        }
        String destroyMethod = element2.getAttribute(DESTROY_METHOD_ATTRIBUTE);
        if (StringUtils.hasLength(destroyMethod)) {
            bd.setDestroyMethodName(destroyMethod);
        } else if (beanDefinitionDefaults.getDestroyMethodName() != null) {
            bd.setDestroyMethodName(beanDefinitionDefaults.getDestroyMethodName());
        }
        String refreshCheckDelay = element2.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (StringUtils.hasText(refreshCheckDelay)) {
            bd.setAttribute(ScriptFactoryPostProcessor.REFRESH_CHECK_DELAY_ATTRIBUTE, new Long(refreshCheckDelay));
        }
        if (StringUtils.hasText(proxyTargetClass = element2.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE))) {
            Boolean flag = new Boolean(proxyTargetClass);
            bd.setAttribute(ScriptFactoryPostProcessor.PROXY_TARGET_CLASS_ATTRIBUTE, flag);
        }
        ConstructorArgumentValues cav = bd.getConstructorArgumentValues();
        int constructorArgNum = 0;
        cav.addIndexedArgumentValue(constructorArgNum++, value2);
        if (element2.hasAttribute(SCRIPT_INTERFACES_ATTRIBUTE)) {
            cav.addIndexedArgumentValue(constructorArgNum++, element2.getAttribute(SCRIPT_INTERFACES_ATTRIBUTE));
        }
        if (element2.hasAttribute(CUSTOMIZER_REF_ATTRIBUTE)) {
            String customizerBeanName = element2.getAttribute(CUSTOMIZER_REF_ATTRIBUTE);
            if (!StringUtils.hasText(customizerBeanName)) {
                parserContext.getReaderContext().error("Attribute 'customizer-ref' has empty value", element2);
            } else {
                cav.addIndexedArgumentValue(constructorArgNum++, new RuntimeBeanReference(customizerBeanName));
            }
        }
        parserContext.getDelegate().parsePropertyElements(element2, bd);
        return bd;
    }

    private String resolveScriptSource(Element element2, XmlReaderContext readerContext) {
        boolean hasScriptSource = element2.hasAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        List<Element> elements = DomUtils.getChildElementsByTagName(element2, INLINE_SCRIPT_ELEMENT);
        if (hasScriptSource && !elements.isEmpty()) {
            readerContext.error("Only one of 'script-source' and 'inline-script' should be specified.", element2);
            return null;
        }
        if (hasScriptSource) {
            return element2.getAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        }
        if (!elements.isEmpty()) {
            Element inlineElement = elements.get(0);
            return "inline:" + DomUtils.getTextValue(inlineElement);
        }
        readerContext.error("Must specify either 'script-source' or 'inline-script'.", element2);
        return null;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

