/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.RubyNil;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class JRubyScriptUtils {
    public static Object createJRubyObject(String scriptSource, Class[] interfaces2) throws JumpException {
        return JRubyScriptUtils.createJRubyObject(scriptSource, interfaces2, ClassUtils.getDefaultClassLoader());
    }

    public static Object createJRubyObject(String scriptSource, Class[] interfaces2, ClassLoader classLoader) {
        Node scriptRootNode;
        Ruby ruby = JRubyScriptUtils.initializeRuntime();
        IRubyObject rubyObject = ruby.runNormally(scriptRootNode = ruby.parseEval(scriptSource, "", null, 0), false);
        if (rubyObject instanceof RubyNil) {
            String className = JRubyScriptUtils.findClassName(scriptRootNode);
            rubyObject = ruby.evalScriptlet("\n" + className + ".new");
        }
        if (rubyObject instanceof RubyNil) {
            throw new IllegalStateException("Compilation of JRuby script returned RubyNil: " + rubyObject);
        }
        return Proxy.newProxyInstance(classLoader, interfaces2, (InvocationHandler)new RubyObjectInvocationHandler(rubyObject, ruby));
    }

    private static Ruby initializeRuntime() {
        return JavaEmbedUtils.initialize((List)Collections.EMPTY_LIST);
    }

    private static String findClassName(Node rootNode) {
        ClassNode classNode = JRubyScriptUtils.findClassNode(rootNode);
        if (classNode == null) {
            throw new IllegalArgumentException("Unable to determine class name for root node '" + rootNode + "'");
        }
        Colon2Node node4 = (Colon2Node)classNode.getCPath();
        return node4.getName();
    }

    private static ClassNode findClassNode(Node node4) {
        if (node4 instanceof ClassNode) {
            return (ClassNode)node4;
        }
        List children2 = node4.childNodes();
        for (Node child : children2) {
            NewlineNode nn;
            ClassNode found2;
            if (child instanceof ClassNode) {
                return (ClassNode)child;
            }
            if (!(child instanceof NewlineNode) || !((found2 = JRubyScriptUtils.findClassNode((nn = (NewlineNode)child).getNextNode())) instanceof ClassNode)) continue;
            return found2;
        }
        for (Node child : children2) {
            ClassNode found3 = JRubyScriptUtils.findClassNode(child);
            if (!(found3 instanceof ClassNode)) continue;
            return found3;
        }
        return null;
    }

    public static class JRubyExecutionException
    extends NestedRuntimeException {
        public JRubyExecutionException(RaiseException ex2) {
            super(JRubyExecutionException.buildMessage(ex2), ex2);
        }

        private static String buildMessage(RaiseException ex2) {
            RubyException rubyEx = ex2.getException();
            return rubyEx != null && rubyEx.message != null ? rubyEx.message.toString() : "Unexpected JRuby error";
        }
    }

    private static class RubyObjectInvocationHandler
    implements InvocationHandler {
        private final IRubyObject rubyObject;
        private final Ruby ruby;

        public RubyObjectInvocationHandler(IRubyObject rubyObject, Ruby ruby) {
            this.rubyObject = rubyObject;
            this.ruby = ruby;
        }

        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (ReflectionUtils.isEqualsMethod(method)) {
                return this.isProxyForSameRubyObject(args2[0]);
            }
            if (ReflectionUtils.isHashCodeMethod(method)) {
                return this.rubyObject.hashCode();
            }
            if (ReflectionUtils.isToStringMethod(method)) {
                String toStringResult = this.rubyObject.toString();
                if (!StringUtils.hasText(toStringResult)) {
                    toStringResult = ObjectUtils.identityToString(this.rubyObject);
                }
                return "JRuby object [" + toStringResult + "]";
            }
            try {
                IRubyObject[] rubyArgs = this.convertToRuby(args2);
                IRubyObject rubyResult = this.rubyObject.callMethod(this.ruby.getCurrentContext(), method.getName(), rubyArgs);
                return this.convertFromRuby(rubyResult, method.getReturnType());
            }
            catch (RaiseException ex2) {
                throw new JRubyExecutionException(ex2);
            }
        }

        private boolean isProxyForSameRubyObject(Object other) {
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            return ih instanceof RubyObjectInvocationHandler && this.rubyObject.equals(((RubyObjectInvocationHandler)ih).rubyObject);
        }

        private IRubyObject[] convertToRuby(Object[] javaArgs) {
            if (javaArgs == null || javaArgs.length == 0) {
                return new IRubyObject[0];
            }
            IRubyObject[] rubyArgs = new IRubyObject[javaArgs.length];
            int i = 0;
            while (i < javaArgs.length) {
                rubyArgs[i] = JavaEmbedUtils.javaToRuby((Ruby)this.ruby, (Object)javaArgs[i]);
                ++i;
            }
            return rubyArgs;
        }

        private Object convertFromRuby(IRubyObject rubyResult, Class returnType) {
            Object result2 = JavaEmbedUtils.rubyToJava((Ruby)this.ruby, (IRubyObject)rubyResult, (Class)returnType);
            if (result2 instanceof RubyArray && returnType.isArray()) {
                result2 = this.convertFromRubyArray(((RubyArray)result2).toJavaArray(), returnType);
            }
            return result2;
        }

        private Object convertFromRubyArray(IRubyObject[] rubyArray, Class returnType) {
            Class<?> targetType = returnType.getComponentType();
            Object javaArray = Array.newInstance(targetType, rubyArray.length);
            int i = 0;
            while (i < rubyArray.length) {
                IRubyObject rubyObject = rubyArray[i];
                Array.set(javaArray, i, this.convertFromRuby(rubyObject, targetType));
                ++i;
            }
            return javaArray;
        }
    }
}

